/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.params.f;
import com.datastax.data.prepare.util.c;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.Operator;
import java.util.HashMap;
import java.util.List;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillDataOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(FillDataOperator.class);

    static <T> Dataset<T> a(Dataset<T> data, f ... fillMissingValues) {
        if (fillMissingValues.length == 0 || data.count() == 0L) {
            logger.info("Detail parameter of Vacancy is empty or Dataset is empty");
            return data;
        }
        for (f fillMissingValue : fillMissingValues) {
            data = FillDataOperator.a(data, fillMissingValue, c.a(data, fillMissingValue.getAttributeSelector(), fillMissingValue.b(), fillMissingValue.getAttribute(), fillMissingValue.getRegularExpression(), fillMissingValue.getValueType()));
        }
        return data;
    }

    protected static <T> Dataset<T> a(Dataset<T> data, List<f> fillMissingValues) {
        return FillDataOperator.a(data, fillMissingValues.toArray(new f[fillMissingValues.size()]));
    }

    protected static <T> Dataset<T> b(Dataset<T> data, String json) {
        if (json == null || "".equals(json)) {
            return data;
        }
        JSONArray array = JSON.parseArray(json);
        return FillDataOperator.imputeMissingValues(data, array);
    }

    @InsightComponent(name="\u7a7a\u7f3a\u503c\u5904\u7406", type="com.datastax.insight.dataprprocess.imputeMissingValues", description="\u7a7a\u7f3a\u503c\u5904\u7406", order=500701)
    public static <T> Dataset<T> imputeMissingValues(@InsightComponentArg(externalInput=true, name="data", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u53c2\u6570", description="\u586b\u5145\u7a7a\u7f3a\u503c\u8be6\u7ec6\u53c2\u6570") JSONArray array) {
        if (array.isEmpty()) {
            return data;
        }
        f fillMissingValue = new f();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject object = array.getJSONObject(i2);
            fillMissingValue.setAttributeSelector(object.getString("selector"));
            if ("Attribute Name".equals(object.getString("selector"))) {
                fillMissingValue.setAttribute(object.getString("selectorValue"));
            }
            if ("Regular Expression".equals(object.getString("selector"))) {
                fillMissingValue.setRegularExpression(object.getString("selectorValue"));
            }
            if ("Value Type".equals(object.getString("selector"))) {
                fillMissingValue.setValueType(object.getString("selectorValue"));
            }
            fillMissingValue.setFillData(object.getString("method"));
            if ("Value".equals(object.getString("method"))) {
                fillMissingValue.setFillDataValue(object.getString("methodValue"));
            }
            data = FillDataOperator.a(data, fillMissingValue);
        }
        return data;
    }

    private static <T> Dataset<T> a(Dataset<T> data, f fillMissingValue, StructField[] fields) {
        Row[] rows;
        if (fields == null) {
            return data;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if ("Drop Empty".equals(fillMissingValue.getFillData())) {
            String[] temp = new String[fields.length];
            for (int i2 = 0; i2 < fields.length; ++i2) {
                temp[i2] = fields[i2].name();
            }
            return data.na().drop(temp);
        }
        if ("Minimum".equals(fillMissingValue.getFillData())) {
            for (StructField field : fields) {
                if (!(field.dataType() != DataTypes.CalendarIntervalType & field.dataType() != DataTypes.NullType) || (rows = (Row[])data.agg(functions.min((Column)data.col(field.name())), new Column[0]).collect())[0].get(0) == null) continue;
                map.put(field.name(), rows[0].get(0).toString());
            }
        }
        if ("Maximum".equals(fillMissingValue.getFillData())) {
            for (StructField field : fields) {
                if (!(field.dataType() != DataTypes.CalendarIntervalType & field.dataType() != DataTypes.NullType) || (rows = (Row[])data.agg(functions.max((Column)data.col(field.name())), new Column[0]).collect())[0].get(0) == null) continue;
                map.put(field.name(), rows[0].get(0).toString());
            }
        }
        if ("Zero".equals(fillMissingValue.getFillData())) {
            for (StructField field : fields) {
                if (!(field.dataType() != DataTypes.NullType & field.dataType() != DataTypes.CalendarIntervalType)) continue;
                map.put(field.name(), "0");
            }
        }
        if ("Value".equals(fillMissingValue.getFillData())) {
            for (StructField field : fields) {
                if (field.dataType() == DataTypes.NullType || fillMissingValue.getFillDataValue() == null || "".equals(fillMissingValue.getFillDataValue())) continue;
                map.put(field.name(), fillMissingValue.getFillDataValue());
            }
        }
        if ("Average".equals(fillMissingValue.getFillData())) {
            for (StructField field : fields) {
                if (!(field.dataType() != DataTypes.CalendarIntervalType & field.dataType() != DataTypes.DateType & field.dataType() != DataTypes.TimestampType & field.dataType() != DataTypes.BooleanType & field.dataType() != DataTypes.StringType & field.dataType() != DataTypes.NullType & field.dataType() != DataTypes.BinaryType) || (rows = (Row[])data.agg(functions.avg((Column)data.col(field.name())), new Column[0]).collect())[0].get(0) == null) continue;
                map.put(field.name(), rows[0].get(0).toString());
            }
        }
        if (!map.isEmpty()) {
            data = data.na().fill(map);
        }
        map.clear();
        return data;
    }
}

