/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.params.g;
import com.datastax.data.prepare.util.a;
import com.datastax.data.prepare.util.c;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.Operator;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(FilterOperator.class);

    @InsightComponent(name="Filter", description="\u8fc7\u6ee4\u6570\u636e\u96c6")
    public static <T> Dataset<T> filter(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u53c2\u6570", description="Filter\u7ec4\u4ef6\u53c2\u6570") JSONArray array) {
        if (array.isEmpty()) {
            logger.info("Filter\u7ec4\u4ef6\u7684\u53c2\u6570\u4e3a\u7a7a,\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        if (data == null) {
            logger.info("Filter\u7ec4\u4ef6\u53c2\u6570\u4e2d\u7684\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u8fd4\u56denull");
            return null;
        }
        ArrayList<g> filterSections = new ArrayList<g>();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject object = array.getJSONObject(i2);
            g filterSection = new g();
            String column = object.getString("selector").trim();
            if (column.length() == 0) {
                logger.info("Filter\u7ec4\u4ef6\u53c2\u6570\u4e2d\u7684column\u4e3a\u7a7a, \u76f8\u5e94\u7684expression\u4e3a\uff1a " + object.getString("selectorValue") + "value\u4e3a: " + object.getString("method") + ", \u8df3\u8fc7\u8be5\u884c\u6761\u4ef6");
                continue;
            }
            filterSection.setColumn(column);
            filterSection.setExpression(object.getString("selectorValue").trim());
            String value = object.getString("method").trim().replace("%5c", "\\");
            filterSection.setValue(value);
            filterSections.add(filterSection);
        }
        if (filterSections.isEmpty()) {
            logger.info("FilterOperator--\u53c2\u6570\u4e3a\u7a7a\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        return FilterOperator.b(data, filterSections);
    }

    protected static <T> Dataset<T> b(Dataset<T> data, final List<g> filterSections) {
        final int[] positions = new int[filterSections.size()];
        final StructField[] fields = data.schema().fields();
        for (int i2 = 0; i2 < filterSections.size(); ++i2) {
            positions[i2] = -1;
            for (int j2 = 0; j2 < fields.length; ++j2) {
                if (!filterSections.get(i2).getColumn().equals(fields[j2].name())) continue;
                positions[i2] = j2;
                break;
            }
            if (positions[i2] != -1) continue;
            logger.info("FilterOperator--" + filterSections.get(i2).getColumn() + "\u5217\u4e0d\u5b58\u5728");
        }
        Dataset result = data.toDF().filter((FilterFunction)new FilterFunction<Row>(){

            public boolean b(Row r2) throws Exception {
                boolean flag = true;
                for (int i2 = 0; i2 < positions.length; ++i2) {
                    if (positions[i2] == -1 || FilterOperator.a(r2.get(positions[i2]), fields[positions[i2]], (g)filterSections.get(i2))) continue;
                    return false;
                }
                return true;
            }

            public /* synthetic */ boolean call(Object object) throws Exception {
                return this.b((Row)object);
            }
        });
        return result;
    }

    protected static boolean a(Object obj, StructField field, g filterSection) {
        boolean flag2;
        boolean flag1 = obj == null;
        boolean bl = flag2 = filterSection.getValue() == null || filterSection.getValue().length() == 0;
        if (!flag1 && !flag2) {
            if ("equals".equals(filterSection.getExpression())) {
                return FilterOperator.a(obj, filterSection);
            }
            if ("does not equals".equals(filterSection.getExpression())) {
                return !FilterOperator.a(obj, filterSection);
            }
            if ("is in".equals(filterSection.getExpression())) {
                return FilterOperator.b(obj, field, filterSection);
            }
            if ("is not in".equals(filterSection.getExpression())) {
                return !FilterOperator.b(obj, field, filterSection);
            }
            if ("contains".equals(filterSection.getExpression()) && field.dataType() == DataTypes.StringType) {
                return FilterOperator.b(obj, filterSection);
            }
            if ("does not contains".equals(filterSection.getExpression()) && field.dataType() == DataTypes.StringType) {
                return !FilterOperator.b(obj, filterSection);
            }
            if ("start with".equals(filterSection.getExpression()) && field.dataType() == DataTypes.StringType) {
                return FilterOperator.c(obj, filterSection);
            }
            if ("end with".equals(filterSection.getExpression()) && field.dataType() == DataTypes.StringType) {
                return FilterOperator.d(obj, filterSection);
            }
            if ("matches".equals(filterSection.getExpression()) && field.dataType() == DataTypes.StringType) {
                return FilterOperator.e(obj, filterSection);
            }
        } else {
            if ("is missing".equals(filterSection.getExpression())) {
                return flag1;
            }
            if ("is not missing".equals(filterSection.getExpression())) {
                return !flag1;
            }
            if (flag2) {
                logger.info("FilterOperator--" + field.name() + "\u5217, expression\u4e3a" + filterSection.getExpression() + "\u7684value\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        return false;
    }

    private static boolean a(Object obj, g filterSection) {
        String value = filterSection.getValue();
        if (value.contains("&&")) {
            String[] strings;
            for (String s2 : strings = value.split("&&")) {
                s2 = s2.trim();
                if (obj.toString().equals(s2.substring(1, s2.length() - 1))) continue;
                return false;
            }
            return true;
        }
        if (value.contains("||")) {
            String[] strings;
            for (String s3 : strings = value.split("\\|\\|")) {
                s3 = s3.trim();
                if (!obj.toString().equals(s3.substring(1, s3.length() - 1))) continue;
                return true;
            }
            return false;
        }
        return obj.toString().equals(value);
    }

    private static boolean b(Object obj, g filterSection) {
        String value = filterSection.getValue();
        if (value.contains("&&")) {
            String[] strings;
            for (String s2 : strings = value.split("&&")) {
                s2 = s2.trim();
                if (obj.toString().contains(s2.substring(1, s2.length() - 1))) continue;
                return false;
            }
            return true;
        }
        if (value.contains("||")) {
            String[] strings;
            for (String s3 : strings = value.split("\\|\\|")) {
                s3 = s3.trim();
                if (!obj.toString().contains(s3.substring(1, s3.length() - 1))) continue;
                return true;
            }
            return false;
        }
        return obj.toString().contains(value);
    }

    private static boolean c(Object obj, g filterSection) {
        String value = filterSection.getValue();
        if (value.contains("&&")) {
            String[] strings;
            for (String s2 : strings = value.split("&&")) {
                s2 = s2.trim();
                if (obj.toString().startsWith(s2.substring(1, s2.length() - 1))) continue;
                return false;
            }
            return true;
        }
        if (value.contains("||")) {
            String[] strings;
            for (String s3 : strings = value.split("\\|\\|")) {
                s3 = s3.trim();
                if (!obj.toString().startsWith(s3.substring(1, s3.length() - 1))) continue;
                return true;
            }
            return false;
        }
        return obj.toString().startsWith(value);
    }

    private static boolean d(Object obj, g filterSection) {
        String value = filterSection.getValue();
        if (value.contains("&&")) {
            String[] strings;
            for (String s2 : strings = value.split("&&")) {
                s2 = s2.trim();
                if (obj.toString().endsWith(s2.substring(1, s2.length() - 1))) continue;
                return false;
            }
            return true;
        }
        if (value.contains("||")) {
            String[] strings;
            for (String s3 : strings = value.split("\\|\\|")) {
                s3 = s3.trim();
                if (!obj.toString().endsWith(s3.substring(1, s3.length() - 1))) continue;
                return true;
            }
            return false;
        }
        return obj.toString().endsWith(value);
    }

    private static boolean e(Object obj, g filterSection) {
        String value = filterSection.getValue();
        if (value.contains("&&")) {
            String[] strings;
            for (String s2 : strings = value.split("&&")) {
                s2 = s2.trim();
                if (obj.toString().matches(s2.substring(1, s2.length() - 1))) continue;
                return false;
            }
            return true;
        }
        if (value.contains("||")) {
            String[] strings;
            for (String s3 : strings = value.split("\\|\\|")) {
                s3 = s3.trim();
                if (!obj.toString().matches(s3.substring(1, s3.length() - 1))) continue;
                return true;
            }
            return false;
        }
        return obj.toString().matches(value);
    }

    private static boolean b(Object obj, StructField field, g filterSection) {
        String value = filterSection.getValue();
        if (value.contains("&&")) {
            String[] strings;
            for (String s2 : strings = value.split("&&")) {
                if (s2.trim().matches("(\\[|\\()[^\\[\\(\\]\\)]+, ?[^\\[\\(\\]\\)]+(\\]|\\))")) {
                    if (FilterOperator.a(obj, s2.trim(), field, filterSection)) continue;
                    return false;
                }
                throw new a("Filter\u7ec4\u4ef6\u53c2\u6570\u4e2d\u7684column\u4e3a" + filterSection.getColumn() + ", \u76f8\u5e94\u7684expression\u4e3a\uff1a " + filterSection.getExpression() + "value\u4e3a: " + filterSection.getValue() + ", value\u4e0d\u7b26\u5408\u683c\u5f0f, \u8df3\u8fc7\u8be5\u884c\u6761\u4ef6");
            }
            return true;
        }
        if (value.contains("||")) {
            String[] strings;
            for (String s3 : strings = value.split("\\|\\|")) {
                if (s3.trim().matches("(\\[|\\()[^\\[\\(\\]\\)]+, ?[^\\[\\(\\]\\)]+(\\]|\\))")) {
                    if (!FilterOperator.a(obj, s3.trim(), field, filterSection)) continue;
                    return true;
                }
                throw new a("Filter\u7ec4\u4ef6\u53c2\u6570\u4e2d\u7684column\u4e3a" + filterSection.getColumn() + ", \u76f8\u5e94\u7684expression\u4e3a\uff1a " + filterSection.getExpression() + "value\u4e3a: " + filterSection.getValue() + ", value\u4e0d\u7b26\u5408\u683c\u5f0f, \u8df3\u8fc7\u8be5\u884c\u6761\u4ef6");
            }
            return false;
        }
        return FilterOperator.a(obj, value, field, filterSection);
    }

    private static boolean a(Object obj, String value, StructField field, g filterSection) {
        boolean b1 = value.charAt(0) == '[';
        boolean b2 = value.charAt(value.length() - 1) == ']';
        String[] splits = value.substring(1, value.length() - 1).split(",");
        String s1 = splits[0].trim();
        String s2 = splits[1].trim();
        if (s1.length() == 0 || s2.length() == 0) {
            throw new a("FilterOperator--" + field.name() + "\u5217, expression\u4e3a" + filterSection.getExpression() + "\u7684value\u53c2\u6570\u4e0d\u7b26\u5408\u683c\u5f0f");
        }
        if (c.b(field)) {
            double d2;
            double d22;
            double d1;
            try {
                d1 = "-Infinity".equals(s1) ? Double.NEGATIVE_INFINITY : Double.parseDouble(s1);
                double d3 = d22 = "-Infinity".equals(s2) ? Double.POSITIVE_INFINITY : Double.parseDouble(s2);
                if (d1 > d22) {
                    logger.info("FilterOperator--is in\u7684value\u4e2d,\u8303\u56f4" + (b1 ? "[" : "(") + d1 + ", " + d22 + (b2 ? "]" : ")") + ", " + d1 + "\u5927\u4e8e" + d22 + ",\u4e24\u8005\u4e92\u6362");
                    double t2 = d1;
                    d1 = d22;
                    d22 = t2;
                }
                d2 = Double.parseDouble(obj.toString());
            }
            catch (NumberFormatException e2) {
                throw new a("FilterOperator--String\u8f6cDouble\u5931\u8d25");
            }
            return (b1 ? d2 >= d1 : d2 > d1) && (b2 ? d2 <= d22 : d2 < d22);
        }
        if (field.dataType() == DataTypes.DateType || field.dataType() == DataTypes.TimestampType) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                java.util.Date date1 = format.parse(s1);
                java.util.Date date2 = format.parse(s2);
                if (field.dataType() == DataTypes.DateType) {
                    Date date = (Date)obj;
                    int sign1 = date.compareTo(new Date(date1.getTime()));
                    int sign2 = date.compareTo(new Date(date2.getTime()));
                    return (b1 ? sign1 >= 0 : sign1 > 0) && (b2 ? sign2 <= 0 : sign2 < 0);
                }
                if (field.dataType() == DataTypes.TimestampType) {
                    Timestamp timestamp = (Timestamp)obj;
                    int sign1 = timestamp.compareTo(new Date(date1.getTime()));
                    int sign2 = timestamp.compareTo(new Date(date2.getTime()));
                    return (b1 ? sign1 >= 0 : sign1 > 0) && (b2 ? sign2 <= 0 : sign2 < 0);
                }
            }
            catch (ParseException e3) {
                logger.error("FilterOperator--String\u8f6cDate\u5931\u8d25");
                e3.printStackTrace();
            }
        } else {
            logger.info(field.name() + "\u5217\u7684\u7c7b\u578b\u4e0d\u652f\u6301 is in \u64cd\u4f5c, \u7c7b\u578b\u4e3a" + field.dataType().typeName());
        }
        return false;
    }
}

