/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.params.h;
import com.datastax.data.prepare.util.a;
import com.datastax.data.prepare.util.c;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatMapOperator
implements Operator {
    private static Logger logger = LoggerFactory.getLogger(FlatMapOperator.class);

    @InsightComponent(name="\u5217\u62c6\u5206", description="\u5c06\u4e00\u5217\u6309\u7167\u4e00\u5b9a\u89c4\u5219\u62c6\u5206\u6210\u591a\u5217")
    public static <T> Dataset<T> flatMap(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u53c2\u6570", description="\u53c2\u6570") JSONArray array) {
        if (array.isEmpty()) {
            logger.info("\u5217\u62c6\u5206\u7ec4\u4ef6\u53c2\u6570\u4e3a\u7a7a, \u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        if (data == null) {
            logger.info("\u5217\u62c6\u5206\u7ec4\u4ef6\u4e2d\u7684\u6570\u636e\u96c6\u4e3a\u7a7a, \u8fd4\u56de\u7a7a");
            return null;
        }
        ArrayList<h> flatMapParams = new ArrayList<h>();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject jsonObject = array.getJSONObject(i2);
            h flatMapParam = new h();
            String column = jsonObject.getString("selector");
            String pattern = jsonObject.getString("selectorValue");
            int sliceNum = jsonObject.getInteger("method");
            String columnName = jsonObject.getString("methodValue");
            if (sliceNum <= 0) {
                throw new a("\u5206\u5217\u6570\u5c0f\u4e8e\u7b49\u4e8e0,\u82e5\u9009\u4e2d\u5217\u4e2d\u7684\u67d0\u4e00\u4e2a\u503c\u5207\u5206\u540e\u751f\u6210\u503c\u7684\u6570\u91cf\u4e0e\u5176\u4ed6\u4e0d\u7b49,\u4fbf\u4f1a\u62a5\u9519\u3002\u56e0\u6b64\u9700\u8981\u8bbe\u5b9a\u8be5\u503c");
            }
            if (column == null || pattern == null) continue;
            if (columnName == null || columnName.split(";").length != sliceNum) {
                logger.info("\u5207\u5206\u540e\u7684\u5217\u540d\u4e3a\u7a7a\u6216\u8005\u5207\u5206\u540e\u7684\u5217\u6570\u548c\u586b\u5199\u7684\u5206\u5217\u6570\u4e0d\u7b26,\u9ed8\u8ba4\u4e3a\u5217\u540d\u52a0_slice\u52a0\u6570\u503c\u8fed\u52a0(1,2,3...)");
                StringBuffer stringBuffer = new StringBuffer();
                for (int j2 = 0; j2 < sliceNum; ++j2) {
                    stringBuffer.append(column).append("_sp").append(j2 + 1);
                    if (j2 + 1 == sliceNum) continue;
                    stringBuffer.append(";");
                }
                columnName = stringBuffer.toString();
            }
            flatMapParam.setColumn(column);
            flatMapParam.setPattern(pattern);
            flatMapParam.setSliceNum(sliceNum);
            flatMapParam.setSliceColumnName(columnName);
            flatMapParams.add(flatMapParam);
        }
        return FlatMapOperator.c(data, flatMapParams);
    }

    protected static <T> Dataset<T> c(Dataset<T> data, List<h> flatMapParams) {
        SparkSession spark = SparkContextBuilder.getSession();
        HashMap<String, Object[]> schemaRecord = new HashMap<String, Object[]>();
        StructField[] fields = data.schema().fields();
        c.a(fields, schemaRecord);
        final HashMap<Integer, h> infos = new HashMap<Integer, h>();
        for (h flatMapParam : flatMapParams) {
            int position = Integer.valueOf(((Object[])schemaRecord.get(flatMapParam.getColumn()))[0].toString());
            if (infos.containsKey(position)) {
                logger.info("\u5206\u5272\u7684\u5217" + flatMapParam.getColumn() + "\u91cd\u590d,\u8df3\u8fc7");
                continue;
            }
            infos.put(position, flatMapParam);
        }
        JavaRDD javaRDD = data.toDF().javaRDD().map((Function)new Function<Row, Row>(){

            public Row b(Row r2) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i2 = 0; i2 < r2.size(); ++i2) {
                    if (infos.containsKey(i2)) {
                        Object obj = r2.get(i2);
                        int sliceNum = ((h)infos.get(i2)).getSliceNum();
                        if (obj == null) {
                            for (int j2 = 0; j2 < sliceNum; ++j2) {
                                list.add(null);
                            }
                            continue;
                        }
                        String value = obj.toString();
                        String[] values = value.split(((h)infos.get(i2)).getPattern());
                        for (int j3 = 0; j3 < sliceNum; ++j3) {
                            if (j3 < values.length) {
                                list.add(values[j3]);
                                continue;
                            }
                            list.add(null);
                        }
                        continue;
                    }
                    list.add(r2.get(i2));
                }
                return RowFactory.create((Object[])list.toArray());
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.b((Row)object);
            }
        });
        StructType newSchema = new StructType();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (infos.containsKey(i2)) {
                String[] sliceColumnNames;
                String sliceColumnName = ((h)infos.get(i2)).getSliceColumnName();
                for (String name : sliceColumnNames = sliceColumnName.split(";")) {
                    newSchema = newSchema.add(name, DataTypes.StringType, true);
                }
                continue;
            }
            newSchema = newSchema.add(fields[i2]);
        }
        return spark.createDataFrame(javaRDD, newSchema);
    }
}

