/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.datastax.data.prepare.util.a;
import com.datastax.data.prepare.util.c;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.Operator;
import java.util.HashMap;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiStringIndexerOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(MultiStringIndexerOperator.class);

    @InsightComponent(name="StringIndexer", description="\u5c06\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u7d22\u5f15\uff0c\u548c\u6807\u7b7e\u6570\u503c\u5316\u8f6c\u6362\u76f8\u540c\uff0c\u652f\u6301\u591a\u5217\u8f6c\u6362")
    public static <T> Dataset<T> multiStringIndexer(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> dataset, @InsightComponentArg(name="\u5217\u540d", description="\u9700\u8981\u8f6c\u6362\u7684\u5217\u540d\uff0c\u591a\u4e2a\u5217\u540d\u7528\u5206\u53f7\u9694\u5f00") String column, @InsightComponentArg(name="\u8f6c\u6362\u540e\u7684\u5217\u540d", description="\u8f6c\u6362\u751f\u6210\u7684\u7d22\u5f15\u5217\u7684\u5217\u540d\uff0c\u4e0d\u80fd\u4e0e\u73b0\u6709\u5217\u540d\u91cd\u590d") String indexerColumnName) {
        if (dataset == null) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a");
            return null;
        }
        if (column == null || column.length() == 0) {
            throw new NullPointerException("StringIndexer\u7ec4\u4ef6\u7684\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        c.a(dataset.schema().fields(), map);
        String[] columns = column.split(";");
        String[] results = indexerColumnName.split(";");
        if (columns.length != results.length) {
            throw new a("StringIdexer\u7ec4\u4ef6\u7684\u5217\u540d\u548c\u8f6c\u6362\u540e\u7684\u5217\u540d\u7684\u6570\u91cf\u4e0d\u7b49");
        }
        Dataset data = dataset.toDF();
        for (int i2 = 0; i2 < columns.length; ++i2) {
            String c2 = columns[i2].trim();
            String r2 = results[i2].trim();
            if (c2.length() == 0) {
                logger.info("\u5217\u540d\u53c2\u6570\u7684\u7b2c" + (i2 + 1) + "\u4e2a\u53c2\u6570\u53bb\u6389\u524d\u540e\u7a7a\u683c\u540e\u4e3a\u7a7a\uff0c\u8df3\u8fc7");
                continue;
            }
            if (!map.containsKey(c2)) {
                logger.info("\u6570\u636e\u96c6\u4e2d\u627e\u4e0d\u5230" + c2 + "\u5217\uff0c\u8df3\u8fc7");
                continue;
            }
            if (r2.length() == 0) {
                throw new a("\u8f6c\u6362\u540e\u7684\u5217\u540d\u53c2\u6570\u7684\u7b2c" + (i2 + 1) + "\u4e2a\u53c2\u6570\u53bb\u6389\u524d\u540e\u7a7a\u683c\u540e\u4e3a\u7a7a");
            }
            if (map.containsKey(r2)) {
                throw new a("\u8f6c\u6362\u540e\u751f\u6210\u7684\u5217\u540d" + r2 + "\u548c\u73b0\u6709\u5217\u540d\u51b2\u7a81");
            }
            data = new StringIndexer().setInputCol(c2).setOutputCol(r2).fit(data).transform(data);
            map.put(r2, new Object[]{map.size() + 1, DataTypes.IntegerType});
        }
        return data;
    }
}

