/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.FilterOperator;
import com.datastax.data.prepare.spark.dataset.params.g;
import com.datastax.data.prepare.spark.dataset.params.j;
import com.datastax.data.prepare.util.a;
import com.datastax.data.prepare.util.c;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.parquet.Strings;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(ReplaceOperator.class);

    @InsightComponent(name="Replace", description="\u66ff\u6362\u6570\u636e\u96c6\u4e2d\u7684\u503c")
    public static <T> Dataset<T> replace(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u53c2\u6570", description="\u53c2\u6570") JSONObject object) {
        if (object.isEmpty()) {
            logger.info("Replace\u7ec4\u4ef6\u53c2\u6570\u4e3a\u7a7a, \u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        if (data == null) {
            logger.info("Replace\u7ec4\u4ef6\u4e2d\u7684\u6570\u636e\u96c6\u4e3a\u7a7a, \u8fd4\u56de\u7a7a");
            return null;
        }
        String replaceType = object.getString("selector");
        JSONArray array = object.getJSONArray("selectorValue");
        ArrayList<j> replaceAttributes = new ArrayList<j>();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            int j2;
            JSONObject obj = array.getJSONObject(i2);
            j replaceAttribute = new j();
            String attributeSelector = obj.getString("method");
            replaceAttribute.setAttributeSelector(attributeSelector);
            if ("Attribute Name".equals(attributeSelector)) {
                replaceAttribute.setAttribute(obj.getString("methodValue"));
            }
            if ("Regular Expression".equals(attributeSelector)) {
                replaceAttribute.setRegularExpression(obj.getString("methodValue").trim());
            }
            if ("Value Type".equals(attributeSelector)) {
                replaceAttribute.setValueType(obj.getString("methodValue").trim());
            }
            if ("\u66ff\u6362".equals(replaceType)) {
                JSONArray valueReplaceAttributes = obj.getJSONArray("var1");
                for (j2 = 0; j2 < valueReplaceAttributes.size(); ++j2) {
                    JSONObject valueReplaceAttribute = valueReplaceAttributes.getJSONObject(j2);
                    boolean regex = valueReplaceAttribute.getBoolean("var2");
                    String oldValue = valueReplaceAttribute.getString("var3");
                    String newValue = valueReplaceAttribute.getString("var4");
                    if (newValue == null || newValue.length() == 0) {
                        throw new a("Replace\u7ec4\u4ef6\u66ff\u6362\u7684\u67d0\u4e00\u65b0\u503c\u4e3a\u7a7a");
                    }
                    replaceAttribute.a(regex, oldValue, newValue);
                }
            }
            if ("\u6761\u4ef6\u66ff\u6362".equals(replaceType)) {
                JSONArray filters = obj.getJSONArray("var1");
                for (j2 = 0; j2 < filters.size(); ++j2) {
                    JSONObject filter = filters.getJSONObject(j2);
                    g filterSection = new g();
                    String column = filter.getString("column").trim();
                    if (column.length() == 0) {
                        logger.info("Replace\u7ec4\u4ef6\u53c2\u6570\u4e2d\u6761\u4ef6\u7684\u67d0\u4e00column\u4e3a\u7a7a, \u76f8\u5e94\u7684expression\u4e3a\uff1a " + filter.getString("expression") + "value\u4e3a: " + filter.getString("value") + ", \u8df3\u8fc7\u8be5\u884c\u6761\u4ef6");
                        continue;
                    }
                    filterSection.setColumn(column);
                    filterSection.setExpression(filter.getString("expression").trim());
                    filterSection.setValue(filter.getString("value").trim());
                    replaceAttribute.a(filterSection);
                }
                JSONArray valueReplaceAttributes = obj.getJSONArray("var2");
                for (int j3 = 0; j3 < valueReplaceAttributes.size(); ++j3) {
                    JSONObject valueReplaceAttribute = valueReplaceAttributes.getJSONObject(j3);
                    boolean regex = valueReplaceAttribute.getBoolean("var3");
                    String oldValue = valueReplaceAttribute.getString("var4");
                    String newValue = valueReplaceAttribute.getString("var5");
                    if (newValue == null || newValue.length() == 0) {
                        throw new a("Replace\u7ec4\u4ef6\u66ff\u6362\u7684\u67d0\u4e00\u65b0\u503c\u4e3a\u7a7a");
                    }
                    replaceAttribute.a(regex, oldValue, newValue);
                }
            }
            replaceAttributes.add(replaceAttribute);
        }
        return ReplaceOperator.a(data, replaceType, replaceAttributes);
    }

    private static <T> Dataset<T> a(Dataset<T> data, final String replaceType, List<j> replaceAttributes) {
        final HashMap map = new HashMap();
        final StructField[] schema = data.schema().fields();
        for (j replaceAttribute : replaceAttributes) {
            StructField[] fields = c.a(data, replaceAttribute.getAttributeSelector(), replaceAttribute.b(), replaceAttribute.getAttribute(), replaceAttribute.getRegularExpression(), replaceAttribute.getValueType());
            if (fields == null) {
                logger.info("Replace\u7ec4\u4ef6\u4e2d\u9009\u62e9\u5217\u7684\u7ed3\u679c\u4e3a\u7a7a,\u8df3\u8fc7\u8be5\u53c2\u6570");
                continue;
            }
            for (StructField field : fields) {
                if (map.containsKey(field)) {
                    ((List)map.get(field)).add(replaceAttribute);
                    continue;
                }
                ArrayList<j> list = new ArrayList<j>();
                list.add(replaceAttribute);
                map.put(field, list);
            }
        }
        final HashMap<String, Object[]> totalSchema = new HashMap<String, Object[]>();
        c.a(schema, totalSchema);
        JavaRDD javaRDD = data.toDF().javaRDD().map((Function)new Function<Row, Row>(){

            public Row b(Row row) throws Exception {
                Object[] strings = new String[row.length()];
                block0: for (int i2 = 0; i2 < row.length(); ++i2) {
                    boolean flag = false;
                    for (StructField field : map.keySet()) {
                        if (schema[i2] != field) continue;
                        flag = true;
                        break;
                    }
                    if (flag) {
                        for (j replaceAttribute : (List)map.get(schema[i2])) {
                            for (j.a v2 : replaceAttribute.getValueReplaceAttributes()) {
                                String t2;
                                if ("\u6761\u4ef6\u66ff\u6362".equals(replaceType)) {
                                    for (g filterSection : replaceAttribute.getFilterSections()) {
                                        int p2 = Integer.parseInt(((Object[])totalSchema.get(filterSection.getColumn()))[0].toString());
                                        if (p2 == -1) {
                                            logger.info("\u6761\u4ef6\u4e2d\u7684" + filterSection.getColumn() + "\u5217\u4e0d\u5b58\u5728");
                                            continue;
                                        }
                                        if (FilterOperator.a(row.get(p2), schema[p2], filterSection)) continue;
                                        strings[i2] = row.get(i2) == null ? null : row.get(i2).toString();
                                        continue block0;
                                    }
                                }
                                String string = t2 = row.get(i2) == null ? null : row.get(i2).toString();
                                if (t2 == null && Strings.isNullOrEmpty((String)v2.getOldValue()) || v2.getOldValue().equals("*")) {
                                    strings[i2] = v2.getNewValue();
                                    continue;
                                }
                                if (t2 == null) continue;
                                strings[i2] = v2.e() ? (t2.matches(v2.getOldValue()) ? v2.getNewValue() : t2) : (v2.getOldValue().equals(t2) ? v2.getNewValue() : t2);
                            }
                        }
                        continue;
                    }
                    strings[i2] = row.get(i2) == null ? null : row.get(i2).toString();
                }
                return RowFactory.create((Object[])strings);
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.b((Row)object);
            }
        });
        StructType structType = new StructType();
        for (StructField field : schema) {
            structType = structType.add(field.name(), DataTypes.StringType, true);
        }
        return SparkContextBuilder.getSession().createDataFrame(javaRDD, structType);
    }
}

