/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.datastax.data.prepare.spark.dataset.r;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;

public class StockSimilrityOperator
implements Operator {
    private static Logger logger = LoggerFactory.getLogger(StockSimilrityOperator.class);

    @InsightComponent(name="\u52a8\u6001\u76f8\u4f3c\u5ea6(stock)", description="\u76f8\u4f3c\u5ea6\u8ba1\u7b97(stock)")
    public static <T> Dataset<T> computeSim(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<Row> data, @InsightComponentArg(name="\u80a1\u4e1c\u5e10\u53f7\u5217", description="\u80a1\u4e1c\u5e10\u53f7") String shrAcctColumn, @InsightComponentArg(name="\u80a1\u7968\u5217", description="\u80a1\u7968\u5217") String secCodeColumn, @InsightComponentArg(name="\u65e5\u671f\u5217", description="\u65e5\u671f\u5217") String tradDateColumn, @InsightComponentArg(name="\u4ea4\u6613\u65b9\u5411\u5217", description="\u4ea4\u6613\u65b9\u5411\u5217") String tradDircColumn, @InsightComponentArg(name="\u662f\u5426\u540c\u5411\u4ea4\u6613", description="\u662f\u5426\u540c\u5411\u4ea4\u6613", defaultValue="true", items="true;false") boolean limitTradeDirection, @InsightComponentArg(name="\u76f8\u4f3c\u5ea6\u65b9\u6cd5", description="\u76f8\u4f3c\u5ea6\u65b9\u6cd5", defaultValue="maximum_best_match", items="maximum_best_match;average_best_match") String setSimMethodString, @InsightComponentArg(name="\u6700\u5c0f\u6709\u6548\u76f8\u4f3c\u5ea6", description="\u7528\u4e8e\u8fc7\u6ee4\u6389\u4e24\u80a1\u4e1c\u8d26\u6237\u4e4b\u95f4\u76f8\u4f3c\u5ea6\u5c0f\u4e8e\u8be5\u503c\u7684\u6570\u636e\uff0c0\u5230100\u4e4b\u95f4") double minSimFlt, @InsightComponentArg(name="\u6700\u5c0f\u5929\u6570\u9608\u503c", description="\u7528\u4e8e\u8ba1\u7b97\u76f8\u4f3c\u5ea6\u7684\u6700\u5c0f\u5929\u6570\u9608\u503c") int tradeDateThreshold, @InsightComponentArg(name="\u5e02\u573a\u7c7b\u578b\u5217", description="\u5e02\u573a\u7c7b\u578b\u5217\u540d") String mktTypeColumn, @InsightComponentArg(name="\u5e02\u573a\u7c7b\u578b", description="\u5e02\u573a\u7c7b\u578b, 0\u4ee3\u8868\u6caa\u5e02\uff0c1\u4ee3\u8868\u6df1\u5e02", defaultValue="1", items="0;1") String mktType, @InsightComponentArg(name="\u4e2d\u95f4\u6587\u4ef6\u8def\u5f84", description="\u4e2d\u95f4\u6587\u4ef6\u8def\u5f84", defaultValue="${MISC_FOLDER}") String tempPath, @InsightComponentArg(name="\u6279\u5904\u7406\u6570\u91cf", description="\u6279\u5904\u7406\u6570\u91cf", defaultValue="5000") String numString) {
        if (data == null) {
            throw new IllegalArgumentException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        if (setSimMethodString == null || setSimMethodString.length() == 0) {
            throw new IllegalArgumentException("set_similarity_method\u4e3a\u7a7a");
        }
        if (minSimFlt > 100.0 || minSimFlt < 0.0) {
            throw new IllegalArgumentException("min_similarity_flt\u4e0d\u57280\u5230100\u4e4b\u95f4");
        }
        if (tradeDateThreshold < 0) {
            throw new IllegalArgumentException("trade_date_threshold\u5c0f\u4e8e0");
        }
        if (mktTypeColumn == null || mktTypeColumn.trim().isEmpty()) {
            throw new IllegalArgumentException("mkt_type\u7684\u5217\u540d\u4e3a\u7a7a");
        }
        if (mktType == null || mktType.trim().isEmpty()) {
            throw new IllegalArgumentException("mkt_type\u4e3a\u7a7a");
        }
        if (tempPath == null || tempPath.trim().isEmpty()) {
            throw new IllegalArgumentException("tempPath\u4e3a\u7a7a");
        }
        int setSimMethod = "maximum_best_match".equals(setSimMethodString) ? 0 : 1;
        SparkSession spark = SparkContextBuilder.getSession();
        return r.a(spark, (Dataset<Row>)data.toDF(), shrAcctColumn, secCodeColumn, tradDateColumn, tradDircColumn, limitTradeDirection, setSimMethod, minSimFlt, tradeDateThreshold, mktTypeColumn, mktType, tempPath, Integer.parseInt(numString));
    }

    @InsightComponent(name="\u9759\u6001\u76f8\u4f3c\u5ea6(stock)", description="\u8ba1\u7b97\u9759\u6001\u7684\u76f8\u4f3c\u5ea6")
    public static <T> Dataset<T> computeStaticSim(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u8bc1\u5238\u8d26\u6237\u4ee3\u7801\u5217", description="\u8bc1\u5238\u8d26\u6237\u4ee3\u7801\u5217") String sec_acct_code, @InsightComponentArg(name="\u624b\u673a\u53f7\u7801\u5217", description="\u624b\u673a\u53f7\u7801\u5217") String mob_nbr, @InsightComponentArg(name="\u56fa\u5b9a\u6216\u5907\u7528\u8054\u7cfb\u7535\u8bdd\u5217", description="\u56fa\u5b9a\u6216\u5907\u7528\u8054\u7cfb\u7535\u8bdd\u5217") String fix_or_memo_cntct_tel, @InsightComponentArg(name="\u8054\u7cfb\u5730\u5740\u5217", description="\u8054\u7cfb\u5730\u5740\u5217") String cntct_addr, @InsightComponentArg(name="\u7535\u5b50\u90ae\u7bb1\u5217", description="\u7535\u5b50\u90ae\u7bb1\u5217") String email_box, @InsightComponentArg(name="\u8eab\u4efd\u8bc1\u660e\u6587\u4ef6\u53f7\u7801\u5217", description="\u8eab\u4efd\u8bc1\u660e\u6587\u4ef6\u53f7\u7801\u5217") String identifi_file_nbr, @InsightComponentArg(name="\u5f00\u6237\u4ee3\u7406\u673a\u6784\u4ee3\u7801\u5217", description="\u5f00\u6237\u4ee3\u7406\u673a\u6784\u4ee3\u7801\u5217") String open_agt_code, @InsightComponentArg(name="\u5f00\u6237\u4ee3\u7406\u7f51\u70b9\u4ee3\u7801\u5217", description="\u5f00\u6237\u4ee3\u7406\u7f51\u70b9\u4ee3\u7801\u5217") String open_agt_net_code, @InsightComponentArg(name="\u5f00\u6237\u65e5\u671f\u5217", description="\u5f00\u6237\u65e5\u671f\u5217") String open_date, @InsightComponentArg(name="\u6700\u5c0f\u76f8\u4f3c\u5ea6", description="\u7528\u4e8e\u8fc7\u6ee4\u6389\u6570\u636e\u96c6\u4e2d\u76f8\u4f3c\u5ea6\u5c0f\u4e8e\u8be5\u503c\u7684\u6570\u636e") double minSim) {
        SparkSession spark = SparkContextBuilder.getSession();
        spark.udf().register("staticSimUDF", (UDF2)new UDF2<Seq<String>, Seq<String>, Double>(){

            public Double a(Seq<String> stringSeq, Seq<String> stringSeq2) throws Exception {
                return r.a(stringSeq, stringSeq2);
            }

            public /* synthetic */ Object call(Object object, Object object2) throws Exception {
                return this.a((Seq<String>)((Seq)object), (Seq<String>)((Seq)object2));
            }
        }, DataTypes.DoubleType);
        return r.a(spark, (Dataset<Row>)data.toDF(), sec_acct_code, mob_nbr, fix_or_memo_cntct_tel, cntct_addr, email_box, identifi_file_nbr, open_agt_code, open_agt_net_code, open_date, minSim);
    }
}

