/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.params.k;
import com.datastax.data.prepare.util.c;
import com.datastax.data.prepare.util.d;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeTransformOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(TypeTransformOperator.class);

    protected static <T> Dataset<T> a(Dataset<T> data, k ... typeTransforms) {
        if (typeTransforms.length == 0 || data == null) {
            logger.info("Detail parameter of Type-transformation is empty or Dataset is empty");
            return data;
        }
        for (k t2 : typeTransforms) {
            t2.setInvertSelection(false);
            StructField[] fields = c.a(data, t2.getAttributeSelector(), t2.b(), t2.getAttribute(), t2.getRegularExpression(), t2.getValueType());
            data = TypeTransformOperator.a(data, fields, t2);
        }
        return data;
    }

    protected static <T> Dataset<T> d(Dataset<T> data, List<k> typeTransforms) {
        return TypeTransformOperator.a(data, typeTransforms.toArray(new k[typeTransforms.size()]));
    }

    protected static <T> Dataset<T> f(Dataset<T> data, String json) {
        if (json == null || "".equals(json)) {
            return data;
        }
        JSONArray array = JSON.parseArray(json);
        return TypeTransformOperator.typeTransform(data, array);
    }

    @InsightComponent(name="\u6570\u636e\u7c7b\u578b\u5904\u7406", type="com.datastax.insight.dataprprocess.typeTransform", description="\u6570\u636e\u7c7b\u578b\u5904\u7406", order=500213)
    public static <T> Dataset<T> typeTransform(@InsightComponentArg(externalInput=true, name="data", description="\u5f85\u6570\u636e\u7c7b\u578b\u5904\u7406\u7684\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u53c2\u6570", description="\u6570\u636e\u7c7b\u578b\u5904\u7406\u7684\u8be6\u7ec6\u53c2\u6570") JSONArray array) {
        if (array.isEmpty()) {
            return data;
        }
        k typeTransform = new k();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject object = array.getJSONObject(i2);
            typeTransform.setAttributeSelector(object.getString("selector"));
            if ("Attribute Name".equals(object.getString("selector"))) {
                typeTransform.setAttribute(object.getString("selectorValue"));
            }
            if ("Regular Expression".equals(object.getString("selector"))) {
                typeTransform.setRegularExpression(object.getString("selectorValue"));
            }
            if ("Value Type".equals(object.getString("selector"))) {
                typeTransform.setValueType(object.getString("selectorValue"));
            }
            typeTransform.setType(object.getString("method"));
            if ("Format Number".equals(object.getString("method"))) {
                typeTransform.setNumberFormat(object.getString("methodValue"));
                typeTransform.setRoundingMode(object.getString("selectMethodValue"));
            }
            data = TypeTransformOperator.a(data, typeTransform);
        }
        return data;
    }

    private static <T> Dataset<T> a(Dataset data, StructField[] fields, k t2) {
        if (Strings.isNullOrEmpty((String)t2.getType()) || fields == null) {
            logger.info("None of attributes is selected or Type is empty");
            return data;
        }
        SparkSession session = SparkContextBuilder.getSession();
        if ("Number to Date".equals(t2.getType())) {
            d.b(session.udf());
            for (StructField structField : fields) {
                if (structField.dataType() != DataTypes.LongType) continue;
                data = data.withColumn(structField.name(), functions.callUDF((String)"num2date", (Column[])new Column[]{data.col(structField.name())}));
            }
        }
        if ("Date to Number".equals(t2.getType())) {
            d.c(session.udf());
            d.d(session.udf());
            for (StructField structField : fields) {
                if (structField.dataType() == DataTypes.TimestampType) {
                    data = data.withColumn(structField.name(), functions.callUDF((String)"timestamp2num", (Column[])new Column[]{data.col(structField.name())}));
                }
                if (structField.dataType() != DataTypes.DateType) continue;
                data = data.withColumn(structField.name(), functions.callUDF((String)"date2num", (Column[])new Column[]{data.col(structField.name())}));
            }
        }
        if ("Format Number".equals(t2.getType())) {
            if (Strings.isNullOrEmpty((String)t2.getNumberFormat())) {
                return data;
            }
            d.a(session.udf(), t2.getNumberFormat(), t2.getRoundingMode());
            for (StructField structField : fields) {
                if (!(structField.dataType() == DataTypes.IntegerType | structField.dataType() == DataTypes.ByteType | structField.dataType() == DataTypes.LongType | structField.dataType() == DataTypes.FloatType | structField.dataType() == DataTypes.DoubleType | structField.dataType() == DataTypes.ShortType)) continue;
                data = data.withColumn(structField.name(), functions.callUDF((String)"rounding", (Column[])new Column[]{data.col(structField.name())}));
            }
        }
        if ("String to Date".equals(t2.getType())) {
            for (StructField structField : fields) {
                if (structField.dataType() != DataTypes.StringType) continue;
                logger.info(structField.name() + "\u4e0d\u7b26\u5408Date\u683c\u5f0f\u7684\u884c\u5c06\u88ab\u8f6c\u6362\u4e3a\u7a7a");
                d.e(session.udf());
                data = data.withColumn(structField.name(), functions.callUDF((String)"string2dateString", (Column[])new Column[]{data.col(structField.name())}));
                data = data.withColumn(structField.name(), data.col(structField.name()).cast(DataTypes.DateType));
            }
        }
        if ("String to Timestamp".equals(t2.getType())) {
            for (StructField structField : fields) {
                if (structField.dataType() != DataTypes.StringType) continue;
                logger.info(structField.name() + "\u4e0d\u7b26\u5408Timestamp\u683c\u5f0f\u7684\u884c\u5c06\u88ab\u8f6c\u6362\u4e3a\u7a7a");
                d.e(session.udf());
                data = data.withColumn(structField.name(), functions.callUDF((String)"string2dateString", (Column[])new Column[]{data.col(structField.name())}));
                data = data.withColumn(structField.name(), data.col(structField.name()).cast(DataTypes.TimestampType));
            }
        }
        if ("String to Long".equals(t2.getType())) {
            for (StructField structField : fields) {
                if (structField.dataType() != DataTypes.StringType) continue;
                logger.info(structField.name() + "\u4e0d\u7b26\u5408Long\u683c\u5f0f\u7684\u884c\u5c06\u88ab\u8f6c\u6362\u4e3a\u7a7a");
                data = data.withColumn(structField.name(), data.col(structField.name()).cast(DataTypes.LongType));
            }
        }
        if ("String to Double".equals(t2.getType())) {
            for (StructField structField : fields) {
                if (structField.dataType() != DataTypes.StringType) continue;
                logger.info(structField.name() + "\u4e0d\u7b26\u5408Double\u683c\u5f0f\u7684\u884c\u5c06\u88ab\u8f6c\u6362\u4e3a\u7a7a");
                data = data.withColumn(structField.name(), data.col(structField.name()).cast(DataTypes.DoubleType));
            }
        }
        if ("Int to Double".equals(t2.getType())) {
            for (StructField structField : fields) {
                if (structField.dataType() != DataTypes.IntegerType) continue;
                data = data.withColumn(structField.name(), data.col(structField.name()).cast(DataTypes.DoubleType));
            }
        }
        if ("Long to Double".equals(t2.getType())) {
            for (StructField structField : fields) {
                if (structField.dataType() != DataTypes.LongType) continue;
                data = data.withColumn(structField.name(), data.col(structField.name()).cast(DataTypes.DoubleType));
            }
        }
        return data;
    }
}

