/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import com.google.common.base.Strings;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.UDFRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDDOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(UDDOperator.class);

    @InsightComponent(name="\u7528\u6237\u81ea\u5b9a\u51fd\u6570", type="com.datastax.insight.dataprprocess.udd", description="\u7528\u6237\u81ea\u5b9a\u51fd\u6570")
    public static <T> Dataset<T> udd(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="jar\u8def\u5f84", description="jar\u6587\u4ef6\u7684\u8def\u5f84", request=true) String jarPath, @InsightComponentArg(name="\u5168\u9650\u5b9a\u7c7b\u540d", description="\u8981\u8c03\u7528\u7684\u7c7b\u540d", request=true) String className, @InsightComponentArg(name="\u65b9\u6cd5\u540d", description="\u7528\u6237\u81ea\u5b9a\u51fd\u6570\u7684\u5165\u53e3\uff0c\u5305\u542b\u53c2\u6570Dataset\uff0cSparkSession\uff0c\u8fd4\u56de\u5904\u7406\u8fc7\u7684Dataset", request=true) String methodName) {
        if (Strings.isNullOrEmpty((String)jarPath) || Strings.isNullOrEmpty((String)className) || Strings.isNullOrEmpty((String)methodName)) {
            logger.info("\u53c2\u6570\u4e3a\u7a7a\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        File file = new File(jarPath);
        if (!file.exists()) {
            logger.info("jar\u6587\u4ef6\u4e0d\u5b58\u5728");
            return data;
        }
        SparkSession session = SparkContextBuilder.getSession();
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        String temp = "file:" + jarPath;
        try {
            Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
            URL url = new URL(temp);
            addURL.invoke((Object)classLoader, url);
            Class<?> clazz = classLoader.loadClass(className);
            Method method = clazz.getDeclaredMethod(methodName, Dataset.class, UDFRegistration.class);
            Object obj = clazz.newInstance();
            Object o2 = method.invoke(obj, data, session.udf());
            if (o2 instanceof Dataset) {
                data = (Dataset)o2;
            } else {
                logger.info("\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u4e0d\u7b49\u4e8e Dataset");
            }
        }
        catch (NoSuchMethodException e2) {
            logger.error("\u65b9\u6cd5\u4e0d\u5b58\u5728");
            e2.printStackTrace();
        }
        catch (MalformedURLException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
        }
        catch (ClassNotFoundException e6) {
            logger.error("\u7c7b\u4e0d\u5b58\u5728");
            e6.printStackTrace();
        }
        catch (InstantiationException e7) {
            e7.printStackTrace();
        }
        return data;
    }
}

