/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset.database;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;

public class CassandraHandler
implements Operator {
    @InsightComponent(name="loadCassandra", description="loadCassandra")
    public static Dataset<Row> load(final @InsightComponentArg(name="host", description="host", request=true) String host, final @InsightComponentArg(name="keySpace", description="keySpace", request=true) String keySpace, final @InsightComponentArg(name="table", description="table", request=true) String table) {
        Dataset ds = SparkContextBuilder.getSession().read().format("org.apache.spark.sql.cassandra").options((Map)new HashMap<String, String>(){
            {
                this.put("keyspace", keySpace);
                this.put("table", table);
                this.put("spark.cassandra.connection.host", host);
            }
        }).load();
        return ds;
    }

    @InsightComponent(name="saveCassandra", description="saveCassandra")
    public static void save(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", request=true, defaultValue="${output}") Dataset<Row> dataset, final @InsightComponentArg(name="host", description="host", request=true) String host, final @InsightComponentArg(name="keySpace", description="keySpace", request=true) String keySpace, final @InsightComponentArg(name="table", description="table", request=true) String table, @InsightComponentArg(name="saveMode", description="saveMode", request=true, defaultValue="ignore", items="append;overwrite;errorIfExists;ignore") String saveMode) {
        dataset.write().format("org.apache.spark.sql.cassandra").options((Map)new HashMap<String, String>(){
            {
                this.put("keyspace", keySpace);
                this.put("table", table);
                this.put("spark.cassandra.connection.host", host);
            }
        }).mode(CassandraHandler.a(saveMode)).save();
    }

    @InsightComponent(name="excuteCassandra", description="excuteCassandra")
    public static ResultSet excute(@InsightComponentArg(name="keySpace", description="keySpace", request=true) String keySpace, @InsightComponentArg(name="host", description="host", request=true) String host, @InsightComponentArg(name="query", description="query", request=true) String query) {
        Cluster cluster = Cluster.builder().addContactPoint(host).build();
        Session session = cluster.connect(keySpace);
        return session.execute(query);
    }

    private static SaveMode a(String saveMode) {
        switch (saveMode) {
            case "append": {
                return SaveMode.Append;
            }
            case "overwrite": {
                return SaveMode.Overwrite;
            }
            case "errorIfExists": {
                return SaveMode.ErrorIfExists;
            }
            case "ignore": {
                return SaveMode.Ignore;
            }
        }
        return SaveMode.Ignore;
    }
}

