/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset.database;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.database.a;
import com.datastax.data.prepare.spark.dataset.database.c;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.Operator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;

public class HBaseHandler
implements Operator {
    @InsightComponent(name="loadHbase", description="loadHbase")
    public static Dataset<Row> load(@InsightComponentArg(name="table", description="\u6570\u636e\u5e93\u540d", request=true) String table, @InsightComponentArg(name="zookeepers", description="zookeepers\u5217\u8868,\u4ee5\u5206\u53f7\u9694\u5f00", request=true) String zookeepers, @InsightComponentArg(name="confParams", description="conf\u914d\u7f6e\u6587\u4ef6", request=true) String confParams, @InsightComponentArg(name="jsonProps", description="Hbase\u53c2\u6570\u914d\u7f6e", request=true) JSONObject jsonObject) {
        String action = jsonObject.getString("action");
        if (action.equals("selectAction")) {
            return HBaseHandler.a(table, zookeepers, confParams, jsonObject);
        }
        if (action.equals("filterAction")) {
            return HBaseHandler.b(table, zookeepers, confParams, jsonObject);
        }
        System.out.println("TEST1");
        return null;
    }

    @InsightComponent(name="loadHbase", description="loadHbase")
    public static Dataset<Row> load(@InsightComponentArg(name="table", description="\u6570\u636e\u5e93\u540d", request=true) String table, @InsightComponentArg(name="zookeepers", description="zookeepers\u5217\u8868,\u4ee5\u5206\u53f7\u9694\u5f00", request=true) String zookeepers, @InsightComponentArg(name="confParams", description="conf\u914d\u7f6e\u6587\u4ef6", request=true) String confParams, @InsightComponentArg(name="family", description="\u5217\u65cf", request=true) String family, @InsightComponentArg(name="\u5404\u5217\u540d", description="\u6bcf\u4e00\u5217\u4ee5\u5206\u53f7\u9694\u5f00", request=true) String columns) {
        if (table == null || zookeepers == null || confParams == null || family == null || columns == null) {
            return null;
        }
        return a.a(table.trim(), zookeepers.trim(), confParams.trim(), family.trim(), columns.trim());
    }

    @InsightComponent(name="saveToHbase", description="\u5c06dataset\u6570\u636e\u4fdd\u5b58\u5230\u6570\u636e\u5e93")
    public static void HfileLoad(@InsightComponentArg(name="table", description="\u6570\u636e\u5e93\u540d", request=true) String table, @InsightComponentArg(name="zookeepers", description="zookeepers\u5217\u8868,\u4ee5\u5206\u53f7\u9694\u5f00", request=true) String zookeepers, @InsightComponentArg(name="confParams", description="conf\u914d\u7f6e\u6587\u4ef6", request=true) String confParams, @InsightComponentArg(name="rowKey", description="rowkey\u5217\u5bf9\u5e94\u7684\u5217\u540d", request=true) String rowKey, @InsightComponentArg(name="family", description="\u5217\u65cf\u4ee5\u53ca\u5bf9\u5e94\u7684\u5217", request=true) String family, @InsightComponentArg(name="columnNames", description="columnNames", request=true) String columnNames, @InsightComponentArg(name="columnNames", description="columnNames", request=true) String stagingFolder, @InsightComponentArg(name="dataset", description="\u6570\u636e\u96c6", request=true) Dataset<Row> dataset) {
        System.out.println("hello");
        c.a(table, zookeepers, confParams, rowKey, family, columnNames, stagingFolder, dataset);
    }

    @InsightComponent(name="saveToHbase", description="\u5c06dataset\u6570\u636e\u4fdd\u5b58\u5230\u6570\u636e\u5e93")
    public static void save(@InsightComponentArg(name="table", description="\u6570\u636e\u5e93\u540d", request=true) String table, @InsightComponentArg(name="zookeepers", description="zookeepers\u5217\u8868,\u4ee5\u5206\u53f7\u9694\u5f00", request=true) String zookeepers, @InsightComponentArg(name="confParams", description="conf\u914d\u7f6e\u6587\u4ef6", request=true) String confParams, @InsightComponentArg(name="rowKeyCol", description="rowkey\u540d", request=true) String rowKey, @InsightComponentArg(name="familyAndCols", description="\u5217\u65cf", request=true) String family, @InsightComponentArg(name="colsType", description="\u6bcf\u4e00\u5217\u4ee5\u9017\u53f7\u9694\u5f00", request=true) String cols, @InsightComponentArg(name="dataset", description="\u6570\u636e\u96c6", request=true) Dataset<Row> dataset) {
        HBaseHandler.a(table, zookeepers, confParams, rowKey, family, cols, dataset);
    }

    @InsightComponent(name="saveByGenerateHFile", description="\u5c06dataset\u6570\u636e\u4fdd\u5b58\u5230\u6570\u636e\u5e93")
    public static void saveByGenerateHFile(@InsightComponentArg(name="table", description="\u6570\u636e\u5e93\u540d", request=true) String table, @InsightComponentArg(name="zookeepers", description="zookeepers\u5217\u8868,\u4ee5\u5206\u53f7\u9694\u5f00", request=true) String zookeepers, @InsightComponentArg(name="hdfsPath", description="hdfs\u8def\u5f84\uff0c\u5982 hdfs://node-1:5000", request=true) String hdfsPath, @InsightComponentArg(name="hfilePath", description="hfile\u5728hdfs\u4e0a\u7684\u4e34\u65f6\u5b58\u50a8\u8def\u5f84", request=true) String hfilePath, @InsightComponentArg(name="confParams", description="conf\u914d\u7f6e\u6587\u4ef6", request=true) String confParams, @InsightComponentArg(name="rowKeyCol", description="rowkey\u5217\u5bf9\u5e94\u7684\u5217\u540d", request=true) String rowKeyCol, @InsightComponentArg(name="familyAndCols", description="\u5217\u65cf\u4ee5\u53ca\u5bf9\u5e94\u7684\u5217", request=true) String familyAndCols, @InsightComponentArg(name="colsType", description="\u6bcf\u4e00\u5217\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b", request=true) String colsType, @InsightComponentArg(name="dataset", description="\u6570\u636e\u96c6", request=true) Dataset<Row> dataset) {
        HBaseHandler.a(table, zookeepers, hdfsPath, hfilePath, confParams, rowKeyCol, familyAndCols, colsType, dataset);
    }

    private static void a(String table, String zookeepers, String hdfsPath, String hfilePath, String confParams, final String rowKeyCol, final String family, String allCols, Dataset<Row> dataset) {
        hfilePath = hfilePath.endsWith("/") ? hfilePath + UUID.randomUUID() : hfilePath + "/" + UUID.randomUUID();
        System.out.println("hfilePath: " + hfilePath);
        JavaRDD rowJavaRDD = dataset.dropDuplicates(rowKeyCol, new String[0]).sort(rowKeyCol, new String[0]).javaRDD();
        String[] split = allCols.split(",");
        final java.util.List<String> cols = Arrays.asList(split).stream().sorted().collect(Collectors.toList());
        cols.forEach(r2 -> System.out.println((String)r2));
        JavaRDD rdd1 = rowJavaRDD.mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Row>, java.util.List<Tuple2<ImmutableBytesWritable, KeyValue>>>(){

            public Iterator<java.util.List<Tuple2<ImmutableBytesWritable, KeyValue>>> call(Iterator<Row> rowIterator) throws Exception {
                ArrayList results = new ArrayList();
                while (rowIterator.hasNext()) {
                    Row row = rowIterator.next();
                    ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                    if (row.getAs(rowKeyCol) != null && !row.getAs(rowKeyCol).toString().trim().isEmpty()) {
                        for (int i2 = 0; i2 < cols.size(); ++i2) {
                            if (row.getAs((String)cols.get(i2)) == null || row.getAs((String)cols.get(i2)).toString().trim().isEmpty()) continue;
                            KeyValue keyValue = new KeyValue(Bytes.toBytes((String)row.getAs(rowKeyCol).toString()), family.getBytes(), ((String)cols.get(i2)).getBytes(), row.getAs((String)cols.get(i2)).toString().getBytes());
                            result.add(new Tuple2((Object)new ImmutableBytesWritable(Bytes.toBytes((String)row.getAs(rowKeyCol).toString())), (Object)keyValue));
                        }
                    }
                    results.add(result);
                }
                return results.iterator();
            }
        });
        JavaPairRDD rdd2 = rdd1.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<java.util.List<Tuple2<ImmutableBytesWritable, KeyValue>>, ImmutableBytesWritable, KeyValue>(){

            public Iterator<Tuple2<ImmutableBytesWritable, KeyValue>> a(java.util.List<Tuple2<ImmutableBytesWritable, KeyValue>> tuple2s) throws Exception {
                return tuple2s.iterator();
            }

            public /* synthetic */ Iterator call(Object object) throws Exception {
                return this.a((java.util.List)object);
            }
        });
        a.a((JavaPairRDD<ImmutableBytesWritable, KeyValue>)rdd2, table, zookeepers, confParams, hdfsPath, hfilePath);
    }

    private static Dataset<Row> a(String table, String zookeepers, String confParams, JSONObject jsonObject) {
        JSONArray selections = jsonObject.getJSONArray("selections");
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Object object : selections) {
            String family = JSONObject.parseObject(object.toString()).getString("family");
            JSONArray qualifiersArray = JSONObject.parseArray(JSONObject.parseObject(object.toString()).getString("qualifiers"));
            String[] qualifiers = qualifiersArray.toArray(new String[qualifiersArray.size()]);
            map.put(family, qualifiers);
        }
        JSONArray qualifierTypes = jsonObject.getJSONArray("qualifierTypes");
        HashMap<String, String> mapType = new HashMap<String, String>();
        for (Object object : qualifierTypes) {
            String qualifier = JSONObject.parseObject(object.toString()).getString("qualifier");
            String type = JSONObject.parseObject(object.toString()).getString("type");
            mapType.put(qualifier, type);
        }
        return a.a(table, zookeepers, confParams, (Map<String, String[]>)((Map)JavaConverters.mapAsScalaMapConverter(map).asScala()), (Map<String, String>)((Map)JavaConverters.mapAsScalaMapConverter(mapType).asScala()));
    }

    private static Dataset<Row> b(String table, String zookeepers, String confParams, JSONObject jsonObject) {
        String filterOperator = jsonObject.getString("filterOperator");
        ArrayList filterParams = new ArrayList();
        JSONArray params = jsonObject.getJSONArray("params");
        for (Object object : params) {
            HashMap<String, String> mapParam = new HashMap<String, String>();
            mapParam.put("filter", JSONObject.parseObject(object.toString()).getString("filter"));
            mapParam.put("compareOp", JSONObject.parseObject(object.toString()).getString("compareOp"));
            mapParam.put("comparator", JSONObject.parseObject(object.toString()).getString("comparator"));
            mapParam.put("family", JSONObject.parseObject(object.toString()).getString("family"));
            mapParam.put("qualifier", JSONObject.parseObject(object.toString()).getString("qualifier"));
            mapParam.put("qualifierPrefixs", JSONObject.parseObject(object.toString()).getString("qualifierPrefixs"));
            mapParam.put("value", JSONObject.parseObject(object.toString()).getString("value"));
            mapParam.put("valueType", JSONObject.parseObject(object.toString()).getString("valueType"));
            filterParams.add(mapParam);
        }
        JSONArray qualifierTypes = jsonObject.getJSONArray("qualifierTypes");
        HashMap<String, String> mapType = new HashMap<String, String>();
        for (Object object : qualifierTypes) {
            String qualifier = JSONObject.parseObject(object.toString()).getString("qualifier");
            String type = JSONObject.parseObject(object.toString()).getString("type");
            mapType.put(qualifier, type);
        }
        return a.a(table, zookeepers, confParams, filterOperator, (List<java.util.Map<String, String>>)JavaConversions.asScalaBuffer(filterParams).toList(), (Map<String, String>)((Map)JavaConverters.mapAsScalaMapConverter(mapType).asScala()));
    }

    private static void a(String table, String zookeepers, String confParams, String rowKeyCol, String familyAndCols, String colsType, Dataset<Row> dataset) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String tmp : familyAndCols.split(";")) {
            String[] tmp2 = tmp.split(":");
            map.put(tmp2[0], tmp2[1].split(","));
        }
        JavaRDD rowJavaRDD = dataset.javaRDD().filter((Function & Serializable)row -> {
            Boolean res = row.getAs(rowKeyCol) != null;
            return res;
        });
        JavaPairRDD rdd = rowJavaRDD.mapToPair((PairFunction & Serializable)row -> {
            Put put = null;
            for (Map.Entry entry : map.entrySet()) {
                String family = (String)entry.getKey();
                put = new Put(Bytes.toBytes((String)row.getAs(rowKeyCol).toString()));
                for (String colName : (String[])entry.getValue()) {
                    if (row.getAs(colName) == null || row.getAs(colName).toString().trim().isEmpty()) continue;
                    put.addColumn(family.getBytes(), colName.getBytes(), row.getAs(colName).toString().getBytes());
                }
            }
            return new Tuple2((Object)new ImmutableBytesWritable(), put);
        });
        a.a((JavaPairRDD<ImmutableBytesWritable, Put>)rdd, table, zookeepers, confParams);
    }

    private static byte[] a(Object value, String valueType) {
        byte[] bytes = null;
        switch (valueType) {
            case "Int": {
                bytes = Bytes.toBytes((int)((Integer)value));
                break;
            }
            case "Short": {
                bytes = Bytes.toBytes((short)((Short)value));
                break;
            }
            case "BigDecimal": {
                bytes = Bytes.toBytes((BigDecimal)((BigDecimal)value));
                break;
            }
            case "Long": {
                bytes = Bytes.toBytes((long)((Long)value));
                break;
            }
            case "Double": {
                bytes = Bytes.toBytes((double)((Double)value));
                break;
            }
            case "Float": {
                bytes = Bytes.toBytes((float)((Float)value).floatValue());
                break;
            }
            case "String": {
                bytes = Bytes.toBytes((String)((String)value));
                break;
            }
            case "Boolean": {
                bytes = Bytes.toBytes((boolean)((Boolean)value));
                break;
            }
            default: {
                bytes = Bytes.toBytes((String)((String)value));
            }
        }
        return bytes;
    }
}

