/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset.database;

import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHandler
implements DataSetOperator {
    private static final Logger logger = LoggerFactory.getLogger(HiveHandler.class);

    @InsightComponent(name="hive->dataset", description="hive->dataset")
    public static Dataset<Row> hsql(String ... hqls) {
        SparkSession spark = SparkSession.builder().appName("DataExa-Insight Hive Operator").getOrCreate();
        Dataset result = null;
        for (String sql : hqls) {
            result = spark.sql(sql);
        }
        return result;
    }

    public static Dataset<Row> hsql(String hql) {
        if (!Strings.isNullOrEmpty((String)hql)) {
            String[] sql = hql.split(";");
            return HiveHandler.hsql(sql);
        }
        return null;
    }

    @InsightComponent(name="hive->dataset", description="hive->dataset")
    public static Dataset<Row> hsqlSimple(@InsightComponentArg(name="hqls", description="hqls", request=true) String hql) {
        SparkSession spark = SparkSession.builder().appName("DataExa-Insight Hive Operator").getOrCreate();
        if (!Strings.isNullOrEmpty((String)hql)) {
            return spark.sql(hql);
        }
        return null;
    }

    @InsightComponent(name="hive->table", description="hive->table")
    public static void hive2table(@InsightComponentArg(name="hsqlAndTable", description="hsqlAndTable", request=true) List<Map<String, String>> hsqlMap) {
        SparkSession spark = SparkSession.builder().appName("DataExa-Insight Hive Operator").getOrCreate();
        for (Map<String, String> map : hsqlMap) {
            Dataset result = spark.sql(map.get("hsql").toString());
            result.createOrReplaceTempView(map.get("table").toString());
        }
    }

    @InsightComponent(name="hive->table", description="hive->table")
    public static <T> String hive2table(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", request=true, defaultValue="${output}") Dataset<T> dataset, @InsightComponentArg(name="\u8868\u540d", description="\u8868\u540d", request=true) String table, @InsightComponentArg(name="hsqlAndTable", description="hsqlAndTable", request=true) String sqls) {
        SparkSession spark = SparkSession.builder().appName("DataExa-Insight Hive Operator").getOrCreate();
        if (!Strings.isNullOrEmpty((String)sqls)) {
            String[] hsqlTuple;
            for (String tuple : hsqlTuple = sqls.split(";")) {
                if (Strings.isNullOrEmpty((String)tuple)) continue;
                String[] sqlAndTable = tuple.split("--");
                Dataset result = spark.sql(sqlAndTable[0].trim());
                result.createOrReplaceTempView(sqlAndTable[1].trim());
            }
        }
        dataset.createOrReplaceTempView(table);
        return "true";
    }

    @InsightComponent(name="hive->table", description="hive->table")
    public static <T> void hive2table(@InsightComponentArg(name="hsqlAndTable", description="hsqlAndTable", request=true) String sqls) {
        SparkSession spark = SparkSession.builder().appName("DataExa-Insight Hive Operator").getOrCreate();
        if (!Strings.isNullOrEmpty((String)sqls)) {
            String[] hsqlTuple;
            for (String tuple : hsqlTuple = sqls.split(";")) {
                if (Strings.isNullOrEmpty((String)tuple)) continue;
                String[] sqlAndTable = tuple.split("--");
                Dataset result = spark.sql(sqlAndTable[0].trim());
                result.createOrReplaceTempView(sqlAndTable[1].trim());
            }
        }
    }

    @InsightComponent(name="dataset->table", description="dataset->table")
    public static String dataset2table(@InsightComponentArg(name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", request=true, defaultValue="${output}") Dataset<Row> dataset, @InsightComponentArg(name="\u4e34\u65f6\u8868", description="\u4e34\u65f6\u8868", request=true) String table) {
        if (dataset != null && !Strings.isNullOrEmpty((String)table)) {
            dataset.createOrReplaceTempView(table);
        }
        return "true";
    }

    @InsightComponent(name="dataset->table", description="dataset->table")
    public static StringIndexer dataset2table2(@InsightComponentArg(name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", request=true, defaultValue="${output}") Dataset<Row> dataset, @InsightComponentArg(name="\u4e34\u65f6\u8868", description="\u4e34\u65f6\u8868", request=true) String table) {
        if (dataset != null && !Strings.isNullOrEmpty((String)table)) {
            dataset.createOrReplaceTempView(table);
        }
        return null;
    }
}

