/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset.database;

import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;

public class MongodbHandler
implements Operator {
    @InsightComponent(name="loadMongodb", description="loadMongodb")
    public static Dataset<Row> load(@InsightComponentArg(name="host", description="host", request=true) String host, @InsightComponentArg(name="database", description="database", request=true) String database, @InsightComponentArg(name="table", description="table", request=true) String table) {
        final String inputUri = "mongodb://" + host + "/" + database + "." + table;
        Dataset ds = SparkContextBuilder.getSession().read().format("com.mongodb.spark.sql").options((Map)new HashMap<String, String>(){
            {
                this.put("spark.mongodb.input.uri", inputUri);
                this.put("spark.mongodb.input.partitionerOptions.partitionKey", "_id");
                this.put("spark.mongodb.input.partitionerOptions.partitionSizeMB", "32");
            }
        }).load();
        return ds;
    }

    @InsightComponent(name="saveMongodb", description="saveMongodb")
    public static void save(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", request=true, defaultValue="${output}") Dataset<Row> dataset, @InsightComponentArg(name="host", description="host", request=true) String host, @InsightComponentArg(name="database", description="database", request=true) String database, @InsightComponentArg(name="table", description="table", request=true) String table, @InsightComponentArg(name="saveMode", description="saveMode", request=true, defaultValue="ignore", items="append;overwrite;errorIfExists;ignore") String saveMode) {
        final String outputUri = "mongodb://" + host + "/" + database + "." + table;
        dataset.write().format("com.mongodb.spark.sql").options((Map)new HashMap<String, String>(){
            {
                this.put("spark.mongodb.output.uri", outputUri);
            }
        }).mode(MongodbHandler.a(saveMode)).save();
    }

    private static SaveMode a(String saveMode) {
        switch (saveMode) {
            case "append": {
                return SaveMode.Append;
            }
            case "overwrite": {
                return SaveMode.Overwrite;
            }
            case "errorIfExists": {
                return SaveMode.ErrorIfExists;
            }
            case "ignore": {
                return SaveMode.Ignore;
            }
        }
        return SaveMode.Ignore;
    }
}

