/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset.hierarchicalCluster;

import com.datastax.insight.core.driver.SparkContextBuilder;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Tuple2;

public class a {
    private final JavaSparkContext a = this.a();
    private final Tuple2<Map, Map> b;

    <T> a(Dataset<T> dataset) {
        this.b = this.a(dataset);
    }

    public <T> void a(Dataset<T> dataset, int numSplits, String outputDir) {
        JavaRDD javaRDD = dataset.toJavaRDD().map(new a((Map)this.b._1));
        this.a((JavaRDD<com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a>)javaRDD, numSplits, outputDir);
    }

    private <T> Tuple2<Map, Map> a(Dataset<T> dataset) {
        String[] columns = dataset.columns();
        Dataset ds1 = dataset.select(columns[0], new String[0]).distinct();
        Dataset ds2 = dataset.select(columns[1], new String[0]).distinct();
        HashSet<String> userIds = new HashSet<String>();
        for (Row row : ds1.collectAsList()) {
            userIds.add(row.getString(0));
        }
        for (Row row : ds2.collectAsList()) {
            userIds.add(row.getString(0));
        }
        HashMap<String, Integer> mapuser2id = new HashMap<String, Integer>();
        HashMap<Integer, String> mapid2user = new HashMap<Integer, String>();
        int id = 0;
        for (String str : userIds) {
            mapuser2id.put(str, id);
            mapid2user.put(id, str);
            ++id;
        }
        return new Tuple2(mapuser2id, mapid2user);
    }

    public JavaSparkContext a() {
        JavaSparkContext javaSparkContext = SparkContextBuilder.getJContext();
        return javaSparkContext;
    }

    public JavaSparkContext getSparkContext() {
        return this.a;
    }

    public int getNumPonits() {
        return ((Map)this.b._1).size();
    }

    public Map getIdUserMap() {
        return (Map)this.b._2;
    }

    public void a(String fileLoc, int numSubGraphs) {
        ArrayList idSubgraphs = Lists.newArrayListWithCapacity((int)numSubGraphs);
        for (int i2 = 0; i2 < numSubGraphs; ++i2) {
            idSubgraphs.add(String.valueOf(i2));
        }
        System.out.println("create idSubgraph files: " + fileLoc);
        try {
            this.a.parallelize((List)idSubgraphs, numSubGraphs).saveAsTextFile(fileLoc);
        }
        catch (Exception e2) {
            return;
        }
    }

    private void a(JavaRDD<com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a> javaRDD, int numSplits, String outputDir) {
        JavaPairRDD pointsPairToWrite = javaRDD.coalesce(numSplits, true).mapToPair((PairFunction)new c());
        try {
            pointsPairToWrite.saveAsHadoopFile(outputDir, NullWritable.class, com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable.a.class, SequenceFileOutputFormat.class);
        }
        catch (Exception e2) {
            return;
        }
    }

    public static void a(String hdfsFile) {
        try {
            FileSystem hdfs = FileSystem.get((URI)new URI(hdfsFile), (Configuration)new Configuration());
            Path path = new Path(hdfsFile);
            if (hdfs.exists(path)) {
                hdfs.delete(path, true);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static final class c
    implements PairFunction<com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a, NullWritable, com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable.a> {
        private static final long serialVersionUID = 1L;

        public Tuple2<NullWritable, com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable.a> a(com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a row) throws CloneNotSupportedException {
            return new Tuple2((Object)NullWritable.get(), (Object)new com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable.a(row.a()));
        }

        public /* synthetic */ Tuple2 call(Object object) throws Exception {
            return this.a((com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a)object);
        }
    }

    public static final class b
    implements PairFunction<com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.b, NullWritable, com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable.b> {
        private static final long serialVersionUID = 1L;

        public Tuple2<NullWritable, com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable.b> a(com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.b row) throws CloneNotSupportedException {
            return new Tuple2((Object)NullWritable.get(), (Object)new com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable.b(row.a()));
        }

        public /* synthetic */ Tuple2 call(Object object) throws Exception {
            return this.a((com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.b)object);
        }
    }

    public static final class a<T>
    implements Function<T, com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a> {
        private static final long serialVersionUID = 1L;
        private final Map map;

        public a(Map map) {
            this.map = map;
        }

        public com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a a(T o2) throws CloneNotSupportedException {
            String str = o2.toString().replace("[", "").replace("]", "").trim();
            String[] split = str.toString().split(",");
            Integer left = Integer.valueOf(this.map.get(split[0]).toString());
            Integer right = Integer.valueOf(this.map.get(split[1]).toString());
            Double weight = -new Double(split[2]).doubleValue();
            com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a edge = new com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.a(left, right, weight);
            return edge;
        }

        public /* synthetic */ Object call(Object object) throws Exception {
            return this.a(object);
        }
    }
}

