/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.rdd;

import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.RDDOperator;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;

public class HBaseRDDHandler
implements RDDOperator {
    public static JavaPairRDD load(HBaseConfiguration conf, String table) {
        conf.set("hbase.mapreduce.inputtable", table);
        JavaSparkContext sc = SparkContextBuilder.getJContext();
        JavaPairRDD hBaseRDD = sc.newAPIHadoopRDD((Configuration)conf, TableInputFormat.class, ImmutableBytesWritable.class, Result.class);
        return hBaseRDD;
    }

    public static void save(HBaseConfiguration conf, JavaPairRDD rdd, String table) throws IOException {
        conf.set("hbase.mapred.outputtable", table);
        Job job = Job.getInstance((Configuration)conf);
        job.setOutputFormatClass(TableOutputFormat.class);
        rdd.saveAsNewAPIHadoopDataset(job.getConfiguration());
    }

    public static void hFile(HBaseConfiguration conf, JavaPairRDD rdd, String path) throws IOException {
        rdd.saveAsNewAPIHadoopFile(path, ImmutableBytesWritable.class, KeyValue.class, HFileOutputFormat2.class, (Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hFileToHBase(HBaseConfiguration conf, String path, String tableName) throws Exception {
        LoadIncrementalHFiles load = new LoadIncrementalHFiles((Configuration)conf);
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        Table table = conn.getTable(TableName.valueOf((String)tableName));
        try {
            RegionLocator regionLocator = conn.getRegionLocator(TableName.valueOf((String)tableName));
            Job job = Job.getInstance((Configuration)conf);
            job.setJobName("DumpFile");
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(KeyValue.class);
            HFileOutputFormat2.configureIncrementalLoad((Job)job, (Table)table, (RegionLocator)regionLocator);
            load.doBulkLoad(new Path(path), (HTable)table);
        }
        finally {
            table.close();
            conn.close();
        }
    }
}

