/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.rdd;

import com.datastax.data.prepare.spark.rdd.RDDConverter;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;

public class RDDLoader
implements RDDOperator {
    public static JavaRDD<String> load(String path) {
        JavaSparkContext sc = SparkContextBuilder.getJContext();
        return sc.textFile(path);
    }

    public static <T> JavaRDD<T> load(String path, final RDDConverter converter) {
        JavaRDD<String> lines = RDDLoader.load(path);
        JavaRDD rdd = lines.map(new Function<String, T>(){

            public T a(String line) throws Exception {
                return converter.convert(line);
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.a((String)object);
            }
        });
        return rdd;
    }

    public static JavaRDD<LabeledPoint> loadLibSVMFile(String path) {
        return MLUtils.loadLibSVMFile((SparkContext)SparkContextBuilder.getContext(), (String)path).toJavaRDD();
    }
}

