/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.rdd;

import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.RDDOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;

public class RDDTransformation
implements RDDOperator {
    @InsightComponent(name="RDD \u5411\u91cf\u5316", description="\u5411\u91cf\u5316", icon="arrows", order=500206)
    public static JavaRDD<Vector> denseVector(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5c\u6570\u636e") JavaRDD<String> rdd, @InsightComponentArg(name="delimiter", description="\u5206\u9694\u7b26", defaultValue=";") String delimiter) {
        JavaRDD vectors = rdd.map((Function & Serializable)s2 -> {
            String delim = delimiter;
            if (delim == null || delim.length() == 0) {
                delim = ";";
            }
            String[] sarray = s2.split(delim);
            double[] values = new double[sarray.length];
            for (int i2 = 0; i2 < sarray.length; ++i2) {
                values[i2] = Double.parseDouble(sarray[i2]);
            }
            return Vectors.dense((double[])values);
        });
        return vectors;
    }

    @InsightComponent(name="RDD LabeledPoint\u5316", description="LabeledPoint\u5316", icon="arrows", order=500207)
    public static JavaRDD<LabeledPoint> lpRDD(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5c\u6570\u636e") JavaRDD<String> rdd, @InsightComponentArg(name="delimiter", description="\u5206\u9694\u7b26", defaultValue=";") String delimiter) {
        JavaRDD labeledPoints = rdd.map((Function & Serializable)s2 -> {
            String delim = delimiter;
            if (delim == null || delim.length() == 0) {
                delim = ";";
            }
            String[] sarray = s2.split(delim);
            double[] values = new double[sarray.length];
            for (int i2 = 1; i2 < sarray.length; ++i2) {
                values[i2] = Double.parseDouble(sarray[i2]);
            }
            return new LabeledPoint(Double.parseDouble(sarray[0]), Vectors.dense((double[])values));
        });
        return labeledPoints;
    }

    @InsightComponent(name="RDD Split", description="Split", icon="square-o", order=500502)
    public static JavaRDD<LabeledPoint>[] split(@InsightComponentArg(externalInput=true, name="rdd", description="\u9700\u8981\u5904\u7406\u7684\u6570\u636eRDD", defaultValue="${output}._1") JavaRDD<LabeledPoint> data, @InsightComponentArg(name="weights", description="\u98ce\u683c\u6bd4\u4f8b\uff0c\u7528\u5206\u53f7\u9694\u5f00") String weights) {
        String[] texts = weights.split(";");
        double[] ws = new double[texts.length];
        for (int i2 = 0; i2 < ws.length; ++i2) {
            ws[i2] = Double.parseDouble(texts[i2]);
        }
        return data.randomSplit(ws);
    }

    @InsightComponent(name="RDD Distinct", description="Distinct", icon="arrows", order=50010302)
    public static <T> JavaRDD<T> distinct(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="numPartitions", description="numPartitions", defaultValue="0") int numPartitions) {
        if (numPartitions > 0) {
            return rdd.distinct(numPartitions);
        }
        return rdd.distinct();
    }

    @InsightComponent(name="RDD Coalesce", description="Coalesce", icon="arrows", order=50010507)
    public static <T> JavaRDD<T> coalesce(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="numPartitions", description="numPartitions") int numPartitions, @InsightComponentArg(name="shuffle", description="shuffle") boolean shuffle) {
        return rdd.coalesce(numPartitions, shuffle);
    }

    @InsightComponent(name="RDD Repartition", description="Repartition", icon="arrows", order=50010508)
    public static <T> JavaRDD<T> repartition(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="numPartitions", description="numPartitions") int numPartitions) {
        return rdd.repartition(numPartitions);
    }

    @InsightComponent(name="RDD Sample", description="Sample", icon="arrows", order=500101)
    public static <T> JavaRDD<T> sample(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="withReplacement", description="withReplacement") boolean withReplacement, @InsightComponentArg(name="fraction", description="fraction") double fraction, @InsightComponentArg(name="seed", description="seed") long seed) {
        return rdd.sample(withReplacement, fraction, seed);
    }

    @InsightComponent(name="RDD Union", description="Union", icon="arrows", order=50010506)
    public static <T> JavaRDD<T> union(@InsightComponentArg(externalInput=true, name="left", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="right", description="\u64cd\u4f5cRDD") JavaRDD<T> other) {
        return rdd.union(other);
    }

    @InsightComponent(name="RDD Intersection", description="Intersection", icon="arrows", order=50010509)
    public static <T> JavaRDD<T> intersection(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="other", description="\u64cd\u4f5cRDD") JavaRDD<T> other) {
        return rdd.intersection(other);
    }

    @InsightComponent(name="RDD Subtract", description="Subtract", icon="arrows", order=50010510)
    public static <T> JavaRDD<T> subtract(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="other", description="\u64cd\u4f5cRDD") JavaRDD<T> other, @InsightComponentArg(name="numPartitions", description="numPartitions") int numPartitions) {
        return rdd.subtract(other, numPartitions);
    }

    @InsightComponent(name="RDD \u8bbe\u7f6e\u540d\u79f0", description="\u8bbe\u7f6e\u540d\u79f0", icon="arrows", order=50010805)
    public static <T> JavaRDD<T> setName(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="name", description="\u540d\u79f0") String name) {
        return rdd.setName(name);
    }

    @InsightComponent(name="RDD Glom", description="Glom", icon="arrows", order=500208)
    public static <T> JavaRDD<List<T>> glom(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd) {
        return rdd.glom();
    }

    @InsightComponent(name="RDD Pipe", description="Pipe", icon="arrows", order=500210)
    public static JavaRDD<String> pipe(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<String> rdd, String ... command) {
        ArrayList<String> list = new ArrayList<String>();
        for (String c2 : command) {
            list.add(c2);
        }
        return rdd.pipe(list);
    }

    @InsightComponent(name="RDD Zip", description="Zip", icon="arrows", order=500209)
    public static <T> JavaPairRDD<T, Long> zip(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="type", description="\u7c7b\u578b", items="uniqueid;index") String type) {
        if (type.equals("uniqueid")) {
            return rdd.zipWithUniqueId();
        }
        if (type.equals("index")) {
            return rdd.zipWithIndex();
        }
        return null;
    }

    @InsightComponent(name="RDD Collect", description="Collect", icon="arrows", order=500211)
    public static <T> List<T> collect(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5c\u6570\u636e\u96c6") JavaRDD<T> rdd) {
        return rdd.collect();
    }

    @InsightComponent(name="RDD CollectPartitions", description="CollectPartitions", icon="arrows", order=500212)
    public static <T> List<T>[] collectPartitions(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="partitionIds", description="partitionIds") String pid) {
        String[] pids = pid.split(";");
        int[] partitionIds = new int[pids.length];
        for (int i2 = 0; i2 < pids.length; ++i2) {
            partitionIds[i2] = Integer.parseInt(pids[i2]);
        }
        return rdd.collectPartitions(partitionIds);
    }

    @InsightComponent(name="RDD Count", description="Count", icon="arrows", order=50010401)
    public static <T> Object count(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(externalInput=true, name="byValue", description="byValue") boolean byValue, @InsightComponentArg(name="timeout", description="\u8fd1\u4f3c\u8ba1\u7b97\u7684timeout", defaultValue="0") long timeout, @InsightComponentArg(name="confidence", description="confidence") double confidence) {
        if (byValue) {
            if (timeout > 0L) {
                return rdd.countByValueApprox(timeout, confidence);
            }
            return rdd.countByValue();
        }
        if (timeout > 0L) {
            return rdd.countApprox(timeout, confidence);
        }
        return rdd.count();
    }

    @InsightComponent(name="RDD Take", description="Take", icon="arrows", order=50010105)
    public static <T> List<T> take(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="num", description="num") int num) {
        return rdd.take(num);
    }

    @InsightComponent(name="RDD TakeOrdered", description="TakeOrdered", icon="arrows", order=50010106)
    public static <T> List<T> takeOrdered(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="num", description="num") int num) {
        return rdd.takeOrdered(num);
    }

    @InsightComponent(name="RDD Top", description="Top", icon="arrows", order=50010107)
    public static <T> List<T> top(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="num", description="num") int num) {
        return rdd.top(num);
    }

    @InsightComponent(name="RDD TakeSample", description="TakeSample", icon="arrows", order=500102)
    public static <T> List<T> takeSample(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd, @InsightComponentArg(name="withReplacement", description="withReplacement") boolean withReplacement, @InsightComponentArg(name="num", description="num") int num, @InsightComponentArg(name="seed", description="seed") long seed) {
        return rdd.takeSample(withReplacement, num, seed);
    }

    @InsightComponent(name="RDD First", description="First", icon="arrows", order=50010108)
    public static <T> T first(@InsightComponentArg(externalInput=true, name="rdd", description="\u64cd\u4f5cRDD") JavaRDD<T> rdd) {
        return (T)rdd.first();
    }
}

