/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.util;

import com.datastax.data.prepare.util.a;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.parquet.Strings;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class c {
    private static final Logger logger = LoggerFactory.getLogger(c.class);

    public static <T> StructField[] a(Dataset<T> data, String attributeSelector, boolean invertSelection, String attribute, String regularExpression, String valueType) {
        StructField[] fields = data.schema().fields();
        boolean flag = true;
        if ("Attribute Name".equals(attributeSelector)) {
            if (attribute != null && attribute.length() != 0) {
                Object[] temp = c.a(attribute.split(";"));
                if (temp.length == 0) {
                    logger.info("Attribute Name \u7684\u5c5e\u6027\u4e3a\u7a7a");
                    return null;
                }
                fields = c.a(fields, temp, invertSelection, 1);
                flag = false;
            } else {
                fields = null;
            }
        }
        if ("Regular Expression".equals(attributeSelector)) {
            if (regularExpression != null && !"".equals(regularExpression)) {
                Pattern pattern = Pattern.compile(regularExpression);
                StructField[] temp = new StructField[fields != null ? fields.length : 0];
                int position = 0;
                for (int i2 = 0; i2 < (fields != null ? fields.length : 0); ++i2) {
                    if (invertSelection == pattern.matcher(fields[i2].name()).matches()) continue;
                    temp[position++] = fields[i2];
                }
                fields = temp;
            } else {
                fields = null;
            }
            flag = false;
        }
        if ("Value Type".equals(attributeSelector)) {
            Object[] types = null;
            if ("numeric".equals(valueType)) {
                types = new DataType[]{DataTypes.IntegerType, DataTypes.ByteType, DataTypes.DoubleType, DataTypes.FloatType, DataTypes.LongType, DataTypes.ShortType};
            }
            if ("integer".equals(valueType)) {
                types = new DataType[]{DataTypes.ShortType, DataTypes.IntegerType, DataTypes.ByteType, DataTypes.LongType};
            }
            if ("date".equals(valueType)) {
                types = new DataType[]{DataTypes.DateType};
            }
            if ("timestamp".equals(valueType)) {
                types = new DataType[]{DataTypes.TimestampType};
            }
            if (types == null) {
                types = new DataType[]{DataTypes.StringType, DataTypes.CalendarIntervalType, DataTypes.BinaryType};
            }
            fields = c.a(fields, types, invertSelection, 2);
            flag = false;
        }
        if (flag & invertSelection || fields == null) {
            logger.info("None of Attributes is selected");
            return null;
        }
        return c.a(fields);
    }

    private static StructField[] a(StructField[] fields) {
        int position = fields.length - 1;
        while (fields[position] == null) {
            --position;
        }
        StructField[] temp = new StructField[position + 1];
        System.arraycopy(fields, 0, temp, 0, position + 1);
        return temp;
    }

    private static StructField[] a(StructField[] fields, Object[] temp, boolean invertSelection, int type) {
        StructField[] result = new StructField[fields.length];
        int[] sign = new int[fields.length];
        block0: for (int i2 = 0; i2 < fields.length; ++i2) {
            for (Object aTemp : temp) {
                boolean flag;
                boolean bl = type == 1 ? aTemp.equals(fields[i2].name()) : (flag = aTemp == fields[i2].dataType());
                if (flag) {
                    sign[i2] = 1;
                    continue block0;
                }
                sign[i2] = 0;
            }
        }
        int a2 = invertSelection ? 0 : 1;
        int position = 0;
        for (int i3 = 0; i3 < fields.length; ++i3) {
            if (sign[i3] != a2) continue;
            result[position++] = fields[i3];
        }
        if (position == 0) {
            return null;
        }
        return result;
    }

    public static StructField[] a(StructField[] recordFields, StructField[] fields) {
        if (fields == null) {
            return null;
        }
        int position = 0;
        while (recordFields[position] != null && ++position != recordFields.length) {
        }
        if (position == 0) {
            while (fields[position] != null) {
                recordFields[position] = fields[position];
                if (++position != fields.length) continue;
            }
            return fields;
        }
        if (position == recordFields.length) {
            return null;
        }
        StructField[] temp = new StructField[fields.length];
        int z2 = 0;
        for (int i2 = 0; i2 < fields.length; ++i2) {
            boolean flag = false;
            if (fields[i2] == null) continue;
            for (int j2 = 0; j2 < position; ++j2) {
                if (recordFields[i2] == null || fields[i2] != recordFields[j2]) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            temp[z2++] = fields[i2];
            recordFields[position++] = fields[i2];
        }
        return temp;
    }

    public static boolean b(StructField structField) {
        return structField.dataType() == DataTypes.IntegerType || structField.dataType() == DataTypes.ByteType || structField.dataType() == DataTypes.LongType || structField.dataType() == DataTypes.FloatType || structField.dataType() == DataTypes.DoubleType || structField.dataType() == DataTypes.ShortType;
    }

    public static boolean c(StructField structField) {
        return structField.dataType() == DataTypes.DateType || structField.dataType() == DataTypes.TimestampType;
    }

    public static boolean d(StructField structField) {
        return structField.dataType() instanceof VectorUDT;
    }

    static int a(String roundingMode) {
        switch (roundingMode) {
            case "ROUND_UP": {
                return 0;
            }
            case "ROUND_DOWN": {
                return 1;
            }
            case "ROUND_CEILING": {
                return 2;
            }
            case "ROUND_HALF_UP": {
                return 4;
            }
            case "ROUND_HALF_DOWN": {
                return 5;
            }
            case "ROUND_HALF_EVEN": {
                return 6;
            }
        }
        return 0;
    }

    public static void a(File file, List<File> fileList, String ... suffixs) {
        if (!file.exists()) {
            logger.info("file does not exists");
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File temp : files) {
                if (file.isDirectory()) {
                    c.a(temp, fileList, suffixs);
                    continue;
                }
                if (!c.a(file.getName(), suffixs)) continue;
                fileList.add(file);
            }
        } else if (c.a(file.getName(), suffixs)) {
            fileList.add(file);
        }
    }

    private static boolean a(String fileName, String[] suffixs) {
        if (suffixs.length == 0) {
            return true;
        }
        boolean flag = false;
        for (String suffix : suffixs) {
            if (Strings.isNullOrEmpty((String)suffix) || !fileName.endsWith(suffix)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean a(Row[] rows, String regex) {
        boolean flag = true;
        for (Row row : rows) {
            if (Strings.isNullOrEmpty((String)row.getString(0)) || row.getString(0).matches(regex)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static String[] a(String[] cols) {
        ArrayList<String> list = new ArrayList<String>();
        int i2 = 0;
        for (String s2 : cols) {
            String t2 = s2.trim();
            if (t2.isEmpty()) continue;
            ++i2;
            list.add(t2);
        }
        return list.toArray(new String[i2]);
    }

    public static void a(StructField[] fields, Map<String, Object[]> map) {
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (map.containsKey(fields[i2].name())) {
                throw new a("\u6570\u636e\u96c6\u4e2d\u7684\u5217\u540d\u91cd\u590d\uff0c\u60f3\u60f3\u90fd\u4e0d\u592a\u53ef\u80fd ( *\u30fb\u03c9\u30fb)\u2704\u2570\u3072\u256f");
            }
            Object[] objects = new Object[]{i2, fields[i2].dataType()};
            map.put(fields[i2].name(), objects);
        }
    }
}

