/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Dendrogram
implements Serializable {
    private String name;
    private String value;
    private int size = 6000;
    private static final long serialVersionUID = 1L;
    private List<Dendrogram> children;
    private Dendrogram parent;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<Dendrogram> getChildren() {
        return this.children;
    }

    public void setChildren(List<Dendrogram> children) {
        this.children = children;
    }

    public void addChild(Dendrogram child) {
        if (this.parent == null) {
            this.addChild(this, child);
        } else {
            Dendrogram existed = this.parent.getByName(this.getName());
            this.addChild(existed, child);
        }
    }

    public void addChild(Dendrogram parent, Dendrogram child) {
        if (parent.children == null) {
            parent.setChildren(new ArrayList<Dendrogram>());
        }
        if (!parent.hasChild(child)) {
            parent.getChildren().add(child);
        }
        child.setParent(parent);
    }

    public Dendrogram getByName(String name) {
        for (Dendrogram c2 : this.getChildren()) {
            if (!c2.getName().equals(name)) continue;
            return c2;
        }
        return null;
    }

    public boolean hasChild(Dendrogram child) {
        if (this.children == null) {
            return false;
        }
        for (Dendrogram d2 : this.children) {
            if (!d2.equals(child)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        Dendrogram dendrogram = (Dendrogram)obj;
        return dendrogram.getName().equals(this.getName());
    }

    public void setParent(Dendrogram parent) {
        this.parent = parent;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

