/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.graph;

import com.datastax.graph.Edge;
import com.datastax.graph.Vertex;
import java.util.ArrayList;
import java.util.List;

public class Graph {
    private long id;
    private String name;
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private List<Edge> edges = new ArrayList<Edge>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<Vertex> vertices) {
        this.vertices = vertices;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public void addVertex(Vertex vertex) {
        if (!this.containsVertex(vertex)) {
            this.vertices.add(vertex);
        }
    }

    public boolean containsVertex(Vertex vertex) {
        boolean flag = false;
        for (Vertex v2 : this.vertices) {
            if (!v2.equals(vertex)) continue;
            return true;
        }
        return flag;
    }

    public void addEdge(Edge edge) {
        if (!this.containsEdge(edge)) {
            if (edge != null && edge.getProperties().size() > 0) {
                edge.addPropertiesToList(edge.getProperties());
                edge.addEdgeIds(edge.getId());
            }
            this.edges.add(edge);
        }
    }

    public boolean containsEdge(Edge edge) {
        boolean flag = false;
        for (Edge e2 : this.edges) {
            if (edge.getStart() >= 0L && edge.getEnd() >= 0L && edge.getStart() != edge.getEnd() && e2.getStart() == edge.getStart() && e2.getEnd() == edge.getEnd() && e2.getType().equals(edge.getType())) {
                flag = true;
                if (edge == null || edge.getProperties().size() <= 0) break;
                e2.addPropertiesToList(edge.getProperties());
                e2.addEdgeIds(edge.getId());
                if (e2.getProperties() != null && e2.getProperties().size() != 0) break;
                e2.setProperties(edge.getProperties());
                break;
            }
            if (e2.getStartName() == null || edge.getEndName() == null || !e2.getStartName().equals(edge.getStartName()) || !e2.getEndName().equals(edge.getEndName()) || !e2.getType().equals(edge.getType())) continue;
            flag = true;
            if (edge == null || edge.getProperties().size() <= 0) break;
            e2.addPropertiesToList(edge.getProperties());
            e2.addEdgeIds(edge.getId());
            if (e2.getProperties() != null && e2.getProperties().size() != 0) break;
            e2.setProperties(edge.getProperties());
            break;
        }
        return flag;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }
}

