/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.graph;

import com.datastax.graph.Edge;
import com.datastax.graph.Vertex;

public class Relationship {
    private long id;
    private Vertex start;
    private Vertex end;
    private Edge connection;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Vertex getStart() {
        return this.start;
    }

    public void setStart(Vertex start2) {
        this.start = start2;
    }

    public Vertex getEnd() {
        return this.end;
    }

    public void setEnd(Vertex end) {
        this.end = end;
    }

    public Edge getConnection() {
        return this.connection;
    }

    public void setConnection(Edge connection) {
        this.connection = connection;
    }

    public static Relationship build(String startText, String endText, String conn) {
        Relationship relationship = new Relationship();
        Vertex startV = new Vertex();
        startV.setName(startText);
        relationship.setStart(startV);
        Vertex endV = new Vertex();
        endV.setName(endText);
        relationship.setEnd(endV);
        Edge edge = new Edge();
        edge.setType(conn);
        relationship.setConnection(edge);
        return relationship;
    }

    public String toString() {
        return this.start.getName() + "-" + this.connection.getType() + "->" + this.end.getName();
    }

    public boolean equals(Object obj) {
        Relationship relationship = (Relationship)obj;
        if (this.getStart().getId() == relationship.getStart().getId() && this.getEnd().getId() == relationship.getEnd().getId() && this.getConnection().getType().equals(relationship.getConnection().getType())) {
            return true;
        }
        return this.getStart().getName().equals(relationship.getStart().getName()) && this.getEnd().getName().equals(relationship.getEnd().getName()) && this.getConnection().getType().equals(relationship.getConnection().getType());
    }
}

