/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.graph;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Vertex {
    private long id = -1L;
    private String name;
    private List<String> labels;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private List<String> idColumns;
    private LinkedHashMap<String, String> propertyGroup;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void addProperties(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            this.setProperty(key, properties.get(key));
        }
    }

    public void addLabel(String label) {
        if (null == this.labels) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(label);
    }

    public void addLabels(String[] labels) {
        if (null == labels) {
            return;
        }
        for (String label : labels) {
            this.addLabel(label);
        }
    }

    public LinkedHashMap<String, String> getPropertyGroup() {
        return this.propertyGroup;
    }

    public void setPropertyGroup(LinkedHashMap<String, String> propertyGroup) {
        this.propertyGroup = propertyGroup;
    }

    public List<String> getIdColumns() {
        return this.idColumns;
    }

    public void setIdColumns(List<String> idColumns) {
        this.idColumns = idColumns;
    }

    public boolean equals(Object obj) {
        boolean flag = false;
        Vertex v2 = (Vertex)obj;
        Vertex vertex = this;
        if (v2.getId() == vertex.getId() && v2.getId() != -1L) {
            return true;
        }
        if (v2.getId() != vertex.getId()) {
            return false;
        }
        if (v2.idColumns != null && vertex.idColumns != null) {
            for (String idColumn : this.idColumns) {
                Object p1 = v2.getProperties().get(idColumn);
                Object p2 = vertex.getProperties().get(idColumn);
                if (p1 == null && p2 == null) continue;
                if (p1 == null && p2 != null) {
                    return false;
                }
                if (p1 != null && p2 == null) {
                    return false;
                }
                if (p1.equals(p2)) continue;
                return false;
            }
            return true;
        }
        if (v2 != null && vertex != null && v2.getName() != null && vertex.getName() != null && v2.getName().equals(vertex.getName())) {
            Object o1 = v2.getProperties().get("tag");
            Object o2 = vertex.getProperties().get("tag");
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 != null && o2 != null && o1.toString().equals(o2.toString())) {
                return true;
            }
        }
        return flag;
    }
}

