/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.agent;

import com.datastax.insight.agent.dao.InsightDAO;
import com.datastax.insight.agent.entity.Component;
import com.datastax.insight.agent.ext.SaveFlowResultHandler;
import com.datastax.insight.core.conf.Components;
import com.datastax.insight.core.dag.Parameter;
import com.datastax.insight.core.entity.Cache;
import com.datastax.insight.core.service.PersistService;
import com.datastax.util.lang.StringUtil;
import com.datastax.util.web.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigManager {
    private static Map<String, String> map = new HashMap<String, String>();

    public static void init() {
        ConfigManager.loadCache();
        ConfigManager.loadExtensions();
        InsightDAO dao = new InsightDAO();
        Cache.addCache("dbsources", new ArrayList());
        Cache.addCache("datum", dao.getDatum());
    }

    private static void loadConfig() {
        Properties prop = new Properties();
        InputStream in = ConfigManager.class.getResourceAsStream("/app.properties");
        try {
            prop.load(in);
            for (Object key : prop.keySet()) {
                map.put(key.toString(), prop.get(key).toString());
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static void loadCache() {
        if (Components.getComponents() == null) {
            List<Component> components = new InsightDAO().getSparkComponents();
            ArrayList<com.datastax.insight.core.conf.Component> cList = new ArrayList<com.datastax.insight.core.conf.Component>();
            for (Component c2 : components) {
                cList.add(ConfigManager.clone(c2));
            }
            Components.setComponents(cList);
        }
    }

    private static void loadExtensions() {
        PersistService.setInsightHandler(new SaveFlowResultHandler());
    }

    private static com.datastax.insight.core.conf.Component clone(Component component) {
        List<Parameter> parameters;
        com.datastax.insight.core.conf.Component c2 = new com.datastax.insight.core.conf.Component();
        c2.setId(component.getId());
        c2.setName(component.getName());
        c2.setClassName(component.getClass_name());
        c2.setMethodName(component.getMethod_name());
        c2.setDescription(component.getDescription());
        c2.setIcon(component.getIcon());
        if (component.getInputTypes() != null && component.getInputTypes().length() > 0) {
            String[] inputTypes = JSONUtil.parseArray(component.getInputTypes(), String.class);
            c2.setInputTypes(inputTypes);
        }
        if (component.getOutputTypes() != null && component.getOutputTypes().length() > 0) {
            String[] outputTypes = JSONUtil.parseArray(component.getOutputTypes(), String.class);
            c2.setOutputTypes(outputTypes);
        }
        c2.setShape(component.getShape());
        c2.setType(component.getType());
        c2.setOrderno(component.getOrderno());
        String paramJson = component.getParameter_json();
        if (paramJson != null && paramJson.length() > 0 && paramJson.contains("parameters") && (parameters = JSONUtil.parseList(paramJson = StringUtil.substringIndentLast(paramJson, "\"parameters\":", "]}") + "]", Parameter.class)) != null) {
            c2.setParameters(parameters.toArray(new Parameter[0]));
        }
        return c2;
    }

    public static String getSection(String key) {
        return map.get(key);
    }
}

