/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.agent;

import com.datastax.insight.agent.ConfigManager;
import com.datastax.insight.agent.dao.InsightDAO;
import com.datastax.insight.core.dag.DAG;
import com.datastax.insight.core.entity.Cache;
import com.datastax.insight.core.entity.Context;
import com.datastax.insight.core.service.BigdataService;
import com.datastax.util.web.JSONUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Paths;
import org.apache.spark.sql.SparkSession;

public class SparkAgent {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String address = args[0];
        String schema = args[1];
        String username = args[2];
        String password = args[3];
        String userId = args[4];
        String projectId = args[5];
        String flowId = args[6];
        String batchId = args[7];
        String mode = args[8];
        String hits = args[9];
        String nodeId = args[10];
        String explorationFile = args[11];
        String runMode = args[12];
        Cache.addCache("address", address);
        Cache.addCache("schema", schema);
        Cache.addCache("username", username);
        Cache.addCache("password", password);
        Cache.addCache("userId", userId);
        Cache.addCache("projectId", projectId);
        Cache.addCache("flowId", flowId);
        Cache.addCache("batchId", batchId);
        Cache.addCache("mode", mode);
        Cache.addCache("hits", hits);
        Cache.addCache("nodeId", nodeId);
        Cache.addCache("explorationFile", explorationFile);
        Cache.addCache("runMode", runMode);
        Cache.addCache("flowVersionId", "0");
        if (Integer.parseInt(runMode) == 1) {
            String localStdoutFile = SparkAgent.getLocalStdoutFile(Long.parseLong(userId), flowId, batchId);
            try {
                System.setOut(new PrintStream(new File(localStdoutFile)));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        System.out.println("===DataExa-Insight Flow Params Started===");
        System.out.println("##################################################");
        System.out.println("address: " + address);
        System.out.println("schema: " + schema);
        System.out.println("userId: " + userId);
        System.out.println("projectId: " + projectId);
        System.out.println("flowId: " + flowId);
        System.out.println("batchId: " + batchId);
        System.out.println("mode: " + mode);
        System.out.println("hits: " + hits);
        System.out.println("nodeId: " + nodeId);
        System.out.println("explorationFile: " + explorationFile);
        System.out.println("runMode: " + runMode);
        System.out.println("##################################################");
        System.out.println("===DataExa-Insight Flow Params Ended===");
        ConfigManager.init();
        SparkAgent.systemPropsInit(Long.parseLong(userId));
        SparkSession spark = SparkAgent.init(Long.parseLong(userId));
        try {
            SparkAgent.runCmdId(projectId, flowId, mode, hits, nodeId, explorationFile);
        }
        finally {
            spark.stop();
        }
    }

    private static SparkSession init(long userId) {
        SparkSession.Builder builder = SparkSession.builder().appName("spark-insight");
        InsightDAO dao = new InsightDAO();
        String warehouse = "";
        String metastore = "";
        if (!Strings.isNullOrEmpty((String)warehouse) && !Strings.isNullOrEmpty((String)metastore)) {
            builder.config("spark.sql.warehouse.dir", warehouse).config("hive.metastore.uris", metastore).enableHiveSupport();
        }
        return builder.getOrCreate();
    }

    private static Object runCmdId(String projectId, String flowId, String mode, String hits, String nodeId, String explorationFile) {
        String dagJson = new InsightDAO().getDAGJson(Long.parseLong(projectId), Long.parseLong(flowId));
        if (dagJson == null) {
            System.out.println("\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\uff01");
            return null;
        }
        return SparkAgent.runCmd(dagJson, mode, hits, nodeId, explorationFile);
    }

    private static Object runCmd(String dagJson, String mode, String hits, String nodeId, String explorationFile) {
        DAG dag = JSONUtil.getEntity(dagJson, DAG.class);
        Object ret = BigdataService.invokeDag(dag, mode, hits, nodeId, explorationFile);
        if (ret != null) {
            System.out.println("Execution result : " + ret.toString());
        }
        return ret;
    }

    private static void systemPropsInit(Long userId) {
        String store_path = "/tmp";
        Context.SYSTEM_PROPERTIES.put("${MAIN_FOLDER}", SparkAgent.parsePath(store_path));
        Context.SYSTEM_PROPERTIES.put("${COMPONENT_FOLDER}", SparkAgent.parsePath(store_path + "/component"));
        Context.SYSTEM_PROPERTIES.put("${DATASET_FOLDER}", SparkAgent.parsePath(store_path + "/dataset"));
        Context.SYSTEM_PROPERTIES.put("${MODEL_FOLDER}", SparkAgent.parsePath(store_path + "/model"));
        Context.SYSTEM_PROPERTIES.put("${TASK_FOLDER}", SparkAgent.parsePath(store_path + "/task"));
        Context.SYSTEM_PROPERTIES.put("${MISC_FOLDER}", SparkAgent.parsePath(store_path + "/misc"));
        Context.SYSTEM_PROPERTIES.put("${DRIVER_FOLDER}", SparkAgent.parsePath(store_path + "/driver"));
        Context.SYSTEM_PROPERTIES.put("${LOG_FOLDER}", SparkAgent.parsePath("/tmp/LOG_HOME"));
        Context.SYSTEM_PROPERTIES.put("${TEMP_FOLDER}", SparkAgent.parsePath("/tmp/path"));
    }

    private static String parsePath(String path) {
        String rightPath = path;
        if (!path.startsWith("hdfs")) {
            rightPath = "file://" + path;
        }
        return rightPath;
    }

    private static String getLocalStdoutFile(Long userId, String flowId, String batchId) {
        InsightDAO dao = new InsightDAO();
        String logId = "flow-" + flowId + "-" + batchId;
        String logHome = "/tmp/LOG_HOME";
        return Paths.get(logHome, logId + ".stdout").toString();
    }

    private static Long getFlowVersionId(Long projectId, Long flowId) {
        if (projectId == 0L) {
            return 0L;
        }
        InsightDAO dao = new InsightDAO();
        return dao.getFlowVersionId(flowId);
    }
}

