/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.agent.dao;

import com.datastax.insight.agent.entity.Asset;
import com.datastax.insight.agent.entity.Component;
import com.datastax.insight.agent.entity.Project;
import com.datastax.insight.agent.entity.SettingItem;
import com.datastax.insight.agent.entity.Subject;
import com.datastax.insight.core.entity.Cache;
import com.datastax.insight.core.entity.DBSource;
import com.datastax.insight.core.entity.Datum;
import com.datastax.insight.core.entity.Model;
import com.datastax.util.db.ConnUtil;
import com.datastax.util.lang.StringUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class InsightDAO {
    protected Connection conn;
    private static final String URL = "jdbc:mysql://${db.address}/${db.schema}?useUnicode=true&characterEncoding=UTF-8&allowMultiQueries=true";

    public InsightDAO() {
        String host = URL.replace("${db.address}", Cache.getCache("address").toString()).replace("${db.schema}", Cache.getCache("schema").toString());
        this.conn = ConnUtil.createConnection("com.mysql.jdbc.Driver", host, Cache.getCache("username").toString(), Cache.getCache("password").toString());
    }

    public List<Component> getSparkComponents() {
        QueryRunner qRunner = new QueryRunner();
        String sql = "select * from d_component where platform='spark'";
        List cList = null;
        try {
            cList = (List)((Object)qRunner.query(this.conn, sql, new BeanListHandler<Component>(Component.class)));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6Spark\u7ec4\u4ef6\u5217\u8868\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return cList;
    }

    public List<Component> getAllComponents() {
        QueryRunner qRunner = new QueryRunner();
        String sql = "select * from d_component";
        List cList = null;
        try {
            cList = (List)((Object)qRunner.query(this.conn, sql, new BeanListHandler<Component>(Component.class)));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6\u7ec4\u4ef6\u5217\u8868\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return cList;
    }

    public List<DBSource> getDBSources() {
        QueryRunner qRunner = new QueryRunner();
        String sql = "select ds.id as id,ds.url as url,ds.user as user,ds.password as password,dt.driver_class as driver  from d_dbsource ds,m_dbtype dt where ds.type=dt.id";
        List cList = null;
        try {
            cList = (List)((Object)qRunner.query(this.conn, sql, new BeanListHandler<DBSource>(DBSource.class)));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return cList;
    }

    public List<Model> getModels() {
        QueryRunner qRunner = new QueryRunner();
        String sql = "select id, model_name as name,usage_description as  description,model_path as  path from d_model_manage";
        List cList = null;
        try {
            cList = (List)((Object)qRunner.query(this.conn, sql, new BeanListHandler<Model>(Model.class)));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6\u901a\u7528\u6a21\u578b\u5217\u8868\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return cList;
    }

    public Model getModel(String modelId) {
        QueryRunner qRunner = new QueryRunner();
        String sql = null;
        sql = "select id, model_name as name,usage_description as  description,model_path as  path, model_class as modelClass from d_model_manage where id = ?";
        Long id = Long.parseLong(modelId.substring(2));
        Model model = null;
        try {
            model = qRunner.query(this.conn, sql, (Object)id, new BeanHandler<Model>(Model.class));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6\u901a\u7528\u6a21\u578b\u5217\u8868\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return model;
    }

    public List<Datum> getDatum() {
        QueryRunner qRunner = new QueryRunner();
        String sql = "select id, name, description, node_type as nodeType, parent_id as parentId, file_name as fileName, path from d_data_set";
        List datumList = null;
        try {
            datumList = (List)((Object)qRunner.query(this.conn, sql, new BeanListHandler<Datum>(Datum.class)));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return datumList;
    }

    public String getDAGJson(long projectId, long flowId) {
        String sql = "select dag_json from d_dag_flow where id=?";
        try {
            PreparedStatement pstm = this.conn.prepareStatement(sql);
            pstm.setLong(1, flowId);
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                InputStream inputStream = rs.getAsciiStream(1);
                return StringUtil.streamToString(inputStream);
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    public void saveRestConfig(String name, Long componentId) {
        String sql = "INSERT INTO restservice(`name`, `cid`) VALUES (?, ?);";
        QueryRunner qRunner = new QueryRunner();
        try {
            qRunner.update(this.conn, sql, name, componentId);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public int saveModel(Long flowId, Long batchId, Long flowVersionId, String modelName, String modelClass, String path) {
        int result = -1;
        try {
            Long projectId = this.getProjectId(flowId);
            String flowCodeById = this.getFlowCodeById(flowId);
            QueryRunner runner = new QueryRunner();
            String sql = "select count(*) from d_model_manage where  flow_id=? and flow_type=?";
            long count = (Long)runner.query(this.conn, sql, new ScalarHandler(), flowId, "DAG");
            String identity = this.getModelIdentity(System.currentTimeMillis());
            Long uId = -1L;
            Object userId = Cache.getCache("userId");
            if (userId != null) {
                try {
                    uId = Long.parseLong(userId.toString());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            Project project = this.getProjectById(projectId);
            Long subject_id = -1L;
            String projectName = "";
            String subjectName = "";
            String subjectCode = "";
            String assetCode = "";
            String assetTypeCode = "";
            if (project != null) {
                Asset asset;
                projectName = project.getName();
                if (project.getSubject_id() != null) {
                    Subject subject = this.getSubjectById(project.getSubject_id());
                    subject_id = project.getSubject_id();
                    if (subject != null) {
                        subjectName = subject.getName();
                        subjectCode = subject.getCode();
                    }
                }
                if (project.getAsset_id() != null && (asset = this.getAssetById(project.getAsset_id())) != null) {
                    assetCode = asset.getAsset_code();
                    if (asset.getAsset_type_id() != null) {
                        assetTypeCode = this.getAssetTypeCodeById(asset.getAsset_type_id());
                    }
                }
            }
            if (count > 0L) {
                String sql4update = "update d_model_manage set model_name=?, model_class=?, model_path=? ,identity=? ,update_time=? ,model_release=?,model_code=? where   flow_id=? and flow_type=?";
                result = runner.update(this.conn, sql4update, modelName, modelClass, path, identity, new Date(), 0, flowCodeById, flowId, "DAG");
                System.out.println("model is updated with success, path: " + path);
            } else {
                Long maxId = this.getId("d_model_manage");
                String sql4insert = "insert into d_model_manage (id, project_id, flow_id, model_name, model_class, model_path,flow_type,identity,project_name,subject_id,subject_name,subject_code,asset_code,asset_type_code,create_time,status,on_offline,model_tpye,model_release,model_code) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                result = runner.update(this.conn, sql4insert, maxId, projectId, flowId, modelName, modelClass, path, "DAG", identity, projectName, subject_id, subjectName, subjectCode, assetCode, assetTypeCode, new Date(), "NOT_RELEASE", "OFF_LINE", "INTERNAL", 0, flowCodeById);
                System.out.println("model is saved with success, path: " + path);
            }
        }
        catch (SQLException e3) {
            e3.printStackTrace();
        }
        return result;
    }

    public String getFlowCodeById(Long id) {
        QueryRunner qRunner = new QueryRunner();
        String sql = null;
        sql = "SELECT `code` from d_dag_flow WHERE id=?";
        String code = "";
        try {
            PreparedStatement pstm = this.conn.prepareStatement(sql);
            pstm.setLong(1, id);
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                InputStream inputStream = rs.getAsciiStream(1);
                code = StringUtil.streamToString(inputStream);
            }
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6assettype\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return code;
    }

    public Project getProjectById(Long id) {
        QueryRunner qRunner = new QueryRunner();
        String sql = null;
        sql = "select name,asset_id,subject_id from d_project where id = ?";
        Project project = null;
        try {
            project = qRunner.query(this.conn, sql, (Object)id, new BeanHandler<Project>(Project.class));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6poject\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return project;
    }

    public Subject getSubjectById(Long id) {
        QueryRunner qRunner = new QueryRunner();
        String sql = null;
        sql = "select code, name  from d_subject where id = ?";
        Subject subject = null;
        try {
            subject = qRunner.query(this.conn, sql, (Object)id, new BeanHandler<Subject>(Subject.class));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6subject\u5217\u8868\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return subject;
    }

    public Asset getAssetById(Long id) {
        QueryRunner qRunner = new QueryRunner();
        String sql = null;
        sql = "select asset_code,asset_type_id from d_asset where id = ?";
        Asset asset = null;
        try {
            asset = qRunner.query(this.conn, sql, (Object)id, new BeanHandler<Asset>(Asset.class));
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6asset\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return asset;
    }

    public String getAssetTypeCodeById(Long id) {
        QueryRunner qRunner = new QueryRunner();
        String sql = null;
        sql = "select asset_type_code from d_asset_type where id = ?";
        String asset = "";
        try {
            PreparedStatement pstm = this.conn.prepareStatement(sql);
            pstm.setLong(1, id);
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                InputStream inputStream = rs.getAsciiStream(1);
                asset = StringUtil.streamToString(inputStream);
            }
        }
        catch (SQLException ex) {
            System.out.println("\u83b7\u53d6assettype\u65f6\u51fa\u9519\uff1a" + ex.getMessage());
        }
        return asset;
    }

    private String getModelIdentity(Long time) {
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        StringBuilder identity = new StringBuilder(ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault())));
        Random random = new Random();
        int value = random.nextInt(99);
        if (value >= 10) {
            identity.append(value);
        } else {
            identity.append("0" + value);
        }
        return identity.toString();
    }

    private long getId(String key) throws SQLException {
        Long id = null;
        String sqlId = "select pk_value from m_id where pk_name=?";
        QueryRunner runner = new QueryRunner();
        Long maxId = (Long)runner.query(this.conn, sqlId, new ScalarHandler(), key);
        if (maxId == null) {
            id = maxId = Long.valueOf(0L);
            Long l2 = maxId;
            Long l3 = maxId = Long.valueOf(maxId + 1L);
            String sql = "insert into m_id(pk_name,pk_value) values(?,?)";
            runner.update(this.conn, sql, key, maxId);
        } else {
            id = maxId;
            Object sql = maxId;
            Long l4 = maxId = Long.valueOf(maxId + 1L);
            sql = "update m_id set pk_value=? where pk_name=?";
            runner.update(this.conn, (String)sql, maxId, key);
        }
        return id;
    }

    public int saveModelMetrics(Long flowId, String metrics) {
        int result;
        block11: {
            result = -1;
            try {
                Long projectId = this.getProjectId(flowId);
                QueryRunner runner = new QueryRunner();
                String sql = "select count(*)  from d_model_manage where  flow_id=? and flow_type=?";
                Long count = (Long)runner.query(this.conn, sql, new ScalarHandler(), flowId, "DAG");
                if (count > 0L) {
                    String sql4update = "update d_model_manage set model_metrics=? where  flow_id=? and flow_type=?";
                    result = runner.update(this.conn, sql4update, metrics, flowId, "DAG");
                    System.out.println("metrics is updated with success");
                    break block11;
                }
                Long maxId = this.getId("d_model_manage");
                Long uId = -1L;
                Object userId = Cache.getCache("userId");
                if (userId != null) {
                    try {
                        uId = Long.parseLong(userId.toString());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                Project project = this.getProjectById(projectId);
                Long subject_id = -1L;
                String projectName = "";
                String subjectName = "";
                String subjectCode = "";
                String assetCode = "";
                String assetTypeCode = "";
                if (project != null) {
                    Asset asset;
                    projectName = project.getName();
                    if (project.getSubject_id() != null) {
                        Subject subject = this.getSubjectById(project.getSubject_id());
                        subject_id = project.getSubject_id();
                        if (subject != null) {
                            subjectName = subject.getName();
                            subjectCode = subject.getCode();
                        }
                    }
                    if (project.getAsset_id() != null && (asset = this.getAssetById(project.getAsset_id())) != null) {
                        assetCode = asset.getAsset_code();
                        if (asset.getAsset_type_id() != null) {
                            assetTypeCode = this.getAssetTypeCodeById(asset.getAsset_type_id());
                        }
                    }
                }
                String sql4insert = "insert into d_model_manage (id, project_id, flow_id, flow_type,project_name,subject_id,subject_name,subject_code,asset_code,asset_type_code,create_time,status,on_offline,model_tpye,model_metrics,create_by) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                result = runner.update(this.conn, sql4insert, maxId, projectId, flowId, "DAG", projectName, subject_id, subjectName, subjectCode, assetCode, assetTypeCode, new Date(), "NOT_RELEASE", "OFF_LINE", "INTERNAL", metrics, userId);
                System.out.println("metrics is saved with success");
            }
            catch (SQLException e3) {
                e3.printStackTrace();
            }
        }
        return result;
    }

    public int saveModelDebugJson(Long flowId, String debugJson) {
        int result = -1;
        try {
            Long projectId = this.getProjectId(flowId);
            QueryRunner runner = new QueryRunner();
            String sql = "select count(*)  from d_model_manage where  flow_id=? and flow_type=?";
            Long count = (Long)runner.query(this.conn, sql, new ScalarHandler(), flowId, "DAG");
            if (count > 0L) {
                String sql4update = "update d_model_manage set debug_json=? where flow_id=? and flow_type=?";
                result = runner.update(this.conn, sql4update, debugJson, flowId, "DAG");
                System.out.println("debugJson is updated with success");
            } else {
                Long maxId = this.getId("d_model_manage");
                String sql4insert = "insert into d_model_manage (id, project_id, flow_id, debug_json) values(?,?,?,?)";
                result = runner.update(this.conn, sql4insert, maxId, projectId, flowId, debugJson);
                System.out.println("debugJson is saved with success");
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public Long getProjectId(Long flowId) {
        Long result = -1L;
        String sql = "select project_id from d_dag_flow where id=?";
        QueryRunner runner = new QueryRunner();
        try {
            result = (Long)runner.query(this.conn, sql, new ScalarHandler(), flowId);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public int saveFlowResult(Long flowId, String resultPath) {
        int result = -1;
        try {
            QueryRunner runner = new QueryRunner();
            String sql4id = "select max(id) from d_flow_result";
            Long maxId = (Long)runner.query(this.conn, sql4id, new ScalarHandler());
            String sql4insert = "insert into d_flow_result (id, flow_id, result_path) values(?,?,?)";
            result = runner.update(this.conn, sql4insert, maxId == null ? 0L : maxId + 1L, flowId, resultPath);
            System.out.println("flow result is saved with success");
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public int updateFlowStatus(Long flowId, Long batchId, int status) {
        int result = -1;
        try {
            String sql = "update d_flow_log set status=?, complete_time=? where flow_id=? and batch_id=?";
            QueryRunner runner = new QueryRunner();
            result = runner.update(this.conn, sql, status, new Timestamp(System.currentTimeMillis()), flowId, batchId);
            System.out.println("flow_log is updated with success");
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public Map<String, String> getSystemSettings(Long userId) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String sql = "select code ,value from m_ccb_setting_item ";
            QueryRunner runner = new QueryRunner();
            List settings = (List)((Object)runner.query(this.conn, sql, new BeanListHandler<SettingItem>(SettingItem.class)));
            if (settings != null) {
                settings.stream().forEach(s2 -> result.put(s2.getCode(), s2.getValue()));
            }
            System.out.println("fetch setting_item with success");
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public Long getFlowVersionId(Long flowId) {
        Long flowVersionId = 0L;
        try {
            String sql = "select flow_version_id from d_flow where id =?";
            QueryRunner runner = new QueryRunner();
            flowVersionId = (Long)runner.query(this.conn, sql, new ScalarHandler(), flowId);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return flowVersionId;
    }
}

