/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.core.dag;

import com.datastax.insight.core.dag.a;
import com.datastax.insight.core.dag.d;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class DAG {
    private long id;
    private String name;
    private List<d> vertices = new ArrayList<d>();
    private List<a> edges = new ArrayList<a>();
    public static final String p = "start";
    public static final String q = "end";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<d> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<d> vertices) {
        this.vertices = vertices;
    }

    public List<a> getEdges() {
        return this.edges;
    }

    public void setEdges(List<a> edges) {
        this.edges = edges;
    }

    public d a(long id) {
        for (d v2 : this.vertices) {
            if (v2.getId() != id) continue;
            return v2;
        }
        return null;
    }

    public d a(String name) {
        for (d v2 : this.vertices) {
            if (!v2.getType().equals(name)) continue;
            return v2;
        }
        return null;
    }

    public List<d> a(long id) {
        ArrayList<d> vertexList = new ArrayList<d>();
        for (a e2 : this.edges) {
            Long source = e2.getSource() == null ? e2.getStart() : e2.getSource();
            if (!source.equals(id)) continue;
            Long target = e2.getTarget() == null ? e2.getEnd() : e2.getTarget();
            d v2 = this.a(target);
            vertexList.add(v2);
        }
        return vertexList;
    }

    public List<d> b(long id) {
        ArrayList<d> vertexList = new ArrayList<d>();
        for (a e2 : this.edges) {
            Long target = e2.getTarget() == null ? e2.getEnd() : e2.getTarget();
            if (!target.equals(id)) continue;
            Long source = e2.getSource() == null ? e2.getStart() : e2.getSource();
            d v2 = this.a(source);
            vertexList.add(v2);
        }
        return vertexList;
    }

    public void a(d vertex) {
        if (!this.a(vertex)) {
            this.vertices.add(vertex);
        }
    }

    public boolean a(d vertex) {
        boolean flag = false;
        for (d v2 : this.vertices) {
            if (v2.getId() != vertex.getId()) continue;
            flag = true;
        }
        return flag;
    }

    public void a(a edge) {
        if (!this.a(edge)) {
            this.edges.add(edge);
        }
    }

    public boolean a(a edge) {
        boolean flag = false;
        for (a e2 : this.edges) {
            Long targetR;
            Long sourceL = e2.getSource() == null ? e2.getStart() : e2.getSource();
            Long sourceR = edge.getSource() == null ? edge.getStart() : edge.getSource();
            Long targetL = e2.getTarget() == null ? e2.getEnd() : e2.getTarget();
            Long l2 = targetR = edge.getTarget() == null ? edge.getEnd() : edge.getTarget();
            if (!sourceL.equals(sourceR) || !targetL.equals(targetR) || !e2.getShape().equals(edge.getShape())) continue;
            flag = true;
        }
        return flag;
    }

    public Optional<a> a(long start2, long end) {
        return this.edges.stream().filter(edge -> edge.getStart() == start2 && edge.getEnd() == end).findAny();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }
}

