/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.core.driver;

import com.datastax.insight.core.conf.Configuration;
import com.datastax.insight.core.driver.SparkConfig;
import com.datastax.util.io.FileUtil;
import com.datastax.util.lang.ProcessStreamHandler;
import com.datastax.util.lang.ProcessUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.spark.launcher.SparkLauncher;

public class Launcher {
    public static final int INTERVAL = 5000;

    public static boolean launch(Configuration configuration, SparkConfig sparkAction, String logId) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("hadoop.home.dir", configuration.getHadoopHome());
        env.put("HADOOP_HOME", configuration.getHadoopHome());
        env.put("spark.home.dir", configuration.getSparkHome());
        env.put("SPARK_HOME", configuration.getSparkHome());
        env.put("HADOOP_CONF_DIR", configuration.getHadoopConfDir());
        if (!Strings.isNullOrEmpty((String)configuration.getYarnConfDir())) {
            env.put("YARN_CONF_DIR", configuration.getYarnConfDir());
        }
        env.put("HADOOP_USER_NAME", configuration.getHadoopUserName());
        try {
            SparkLauncher launcher = new SparkLauncher(env);
            if (!Strings.isNullOrEmpty((String)configuration.getJars())) {
                launcher = launcher.addJar(configuration.getJars());
            }
            launcher = launcher.setAppName("spark-app-" + sparkAction.getAppArgs().get(7)).setAppResource(sparkAction.getAppResource()).setMainClass(sparkAction.getMainClass()).setMaster(sparkAction.getMaster()).setVerbose(sparkAction.isVerbose());
            if (sparkAction.getDeployMode() != null) {
                launcher = launcher.setDeployMode(sparkAction.getDeployMode());
            }
            for (String key : sparkAction.getConfMap().keySet()) {
                launcher = launcher.setConf(key, sparkAction.getConfMap().get(key));
            }
            if (sparkAction.getAppArgs() != null) {
                for (String arg : sparkAction.getAppArgs()) {
                    launcher = launcher.addAppArgs(new String[]{arg});
                }
            }
            if (configuration.getQueue() != null) {
                launcher = launcher.addSparkArg("--conf", "spark.yarn.queue=" + configuration.getQueue());
            }
            Process process = launcher.launch();
            File logFile = Paths.get(configuration.getLogDir(), logId + ".log").toFile();
            SimpleDateFormat dFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
            ProcessStreamHandler handler = "yarn".equals(sparkAction.getMaster()) ? line -> FileUtil.writeFile(logFile, dFormat.format(new Date()) + ";" + line + "\r\n", true) : line -> FileUtil.writeFile(logFile, line + "\r\n", true);
            ProcessUtil processUtil = new ProcessUtil(handler);
            processUtil.unblock(process);
            System.out.println("launcher over");
            File stdoutLogFile = Paths.get(configuration.getLogDir(), logId + ".stdout").toFile();
            return Launcher.a(stdoutLogFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void newThread(final Configuration configuration, final SparkConfig sparkConfig, final String logId) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Launcher.launch(configuration, sparkConfig, logId);
            }
        });
        thread.start();
    }

    private static boolean a(File file) {
        if (file.exists()) {
            String fileData = FileUtil.readFile(file);
            return !fileData.contains("Exception");
        }
        return false;
    }
}

