/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.core.operator.shell;

import com.datastax.insight.core.conf.Configuration;
import com.datastax.insight.core.driver.Launcher;
import com.datastax.insight.core.driver.SparkConfig;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.Operator;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class SparkShell
implements Operator {
    static final String z = ";";

    public static void execute(String appResource, String mainClass, String parameters) throws Exception {
        String[] params;
        SparkSession session = SparkSession.builder().getOrCreate();
        String master = session.sparkContext().master();
        String deployMode = session.sparkContext().deployMode();
        List jars = JavaConversions.seqAsJavaList((Seq)session.sparkContext().jars());
        Configuration configuration = new Configuration();
        Map<String, String> settings = SparkShell.getSettings();
        if (master.startsWith("local")) {
            configuration.setSparkHome(settings.get("SPARK_HOME"));
            configuration.setHadoopHome(settings.get("HADOOP_HOME"));
            configuration.setHadoopConfDir(settings.get("HADOOP_CONF_DIR"));
            configuration.setYarnConfDir(settings.get("YARN_CONF_DIR"));
            configuration.setHadoopUserName(settings.get("HADOOP_USER_NAME"));
            configuration.setLogDir(settings.get("LOG_HOME"));
        }
        SparkConfig sparkAction = new SparkConfig();
        File dstFile = null;
        String dst = null;
        if (master.startsWith("local") && appResource.startsWith("hdfs://")) {
            String tempPath = settings.get("temp.path");
            org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
            String[] fs = FileSystem.get((URI)URI.create(appResource), (org.apache.hadoop.conf.Configuration)conf);
            String fileName = appResource.substring(appResource.lastIndexOf("/") + 1);
            dst = Paths.get(tempPath, fileName).toString();
            dstFile = Paths.get(tempPath, fileName).toFile();
            if (dstFile.exists()) {
                dstFile.delete();
            }
            fs.copyToLocalFile(new Path(appResource), new Path(dst));
            sparkAction.setAppResource(dst);
        } else {
            sparkAction.setAppResource(appResource);
        }
        sparkAction.setMaster(master);
        sparkAction.setDeployMode(deployMode);
        sparkAction.setAppArgs(jars);
        sparkAction.setMainClass(mainClass);
        ArrayList<String> args = new ArrayList<String>();
        for (String param : params = parameters.split(z)) {
            args.add(param);
        }
        sparkAction.setAppArgs(args);
        String logId = "shell-" + System.currentTimeMillis();
        if (master.startsWith("local")) {
            sparkAction.addConf("spark.ui.port", String.valueOf(4040L + System.currentTimeMillis() % 8L + 1L));
            Launcher.launch(configuration, sparkAction, logId);
        } else {
            session.sparkContext().addJar(appResource);
            SparkShell.a(appResource, mainClass, params);
        }
    }

    private static void a(String appResource, String mainClass, String[] args) throws Exception {
        URL url = new URL(appResource);
        URLClassLoader loader = new URLClassLoader(new URL[]{url});
        Class<?> clazz = loader.loadClass(mainClass);
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{args});
    }

    private static Map<String, String> getSettings() {
        Object result = PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "getSystemSettings", new String[]{Long.class.getTypeName()}, new Object[]{0L});
        return (Map)result;
    }
}

