/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.data;

import com.datastax.insight.core.entity.Cache;
import com.datastax.insight.core.entity.Datum;
import com.datastax.insight.ml.spark.data.dataset.DataSetLoader;
import com.datastax.insight.spec.Operator;
import com.datastax.util.io.FileUtil;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class DatumLoader
implements Operator {
    public static String loadDatum(String id) {
        return DatumLoader.a(id).getPath();
    }

    public static Dataset<Row> loadDatum(@NotNull String id, @NotNull String format, Boolean header, String sep) {
        String path = DatumLoader.loadDatum(id);
        return DataSetLoader.load(format, true, path, header, sep);
    }

    public static Dataset<Row> loadFile(@NotNull String path, @NotNull String format, Boolean header, String sep) {
        return DataSetLoader.load(format, false, path, header, sep);
    }

    public static String loadFile(@NotNull String id) {
        String path = DatumLoader.loadDatum(id);
        String absolutePath = DataSetLoader.getDataPath(path);
        String tmpPath = "/tmp/" + id;
        if (absolutePath.startsWith("hdfs:")) {
            DatumLoader.Hdfs2Local(absolutePath, tmpPath);
            return DatumLoader.readFileString(tmpPath);
        }
        return DatumLoader.readFileString(absolutePath);
    }

    public static String loadFile2(@NotNull String id) {
        String path = DatumLoader.loadDatum(id);
        String absolutePath = DataSetLoader.getDataPath(path);
        return DatumLoader.readFileString(absolutePath);
    }

    private static Datum a(String id) {
        List data = (List)Cache.getCache("datum");
        if (data != null) {
            return data.stream().filter(d2 -> String.valueOf(d2.getId()).equals(id) && !Strings.isNullOrEmpty((String)d2.getPath())).findFirst().orElse(null);
        }
        return null;
    }

    public static String readFileString(String path) {
        StringBuffer sb = new StringBuffer();
        for (String line : DatumLoader.readFileText(path)) {
            sb.append(line + "\r\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileText(String path) {
        BufferedReader bufread = null;
        ArrayList<String> texts = new ArrayList<String>();
        try {
            File file = new File(path);
            if (file.exists()) {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
                bufread = new BufferedReader(isr);
            } else {
                InputStream in = FileUtil.class.getResourceAsStream(path);
                bufread = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            }
            try {
                try {
                    String read;
                    while ((read = bufread.readLine()) != null) {
                        texts.add(read);
                    }
                }
                catch (IOException var10) {
                    var10.printStackTrace();
                }
            }
            finally {
                if (bufread != null) {
                    bufread.close();
                }
            }
        }
        catch (Exception var12) {
            var12.printStackTrace();
        }
        return texts;
    }

    public static void Hdfs2Local(String src, String dst) {
        try {
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.get((URI)URI.create(src), (Configuration)conf);
            Path srcPath = new Path(src);
            Path dstPath = new Path(dst);
            fs.copyToLocalFile(srcPath, dstPath);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

