/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.data.dataset;

import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.core.entity.Cache;
import com.datastax.insight.core.entity.DBSource;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.Operator;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.spark.dataset.a;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class DataSetLoader
implements Operator {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static Dataset<Row> file(String type, String path) {
        if (type.equals("csv")) {
            return DataSetLoader.csv(path);
        }
        if (type.equals("text")) {
            return DataSetLoader.text(path);
        }
        if (type.equals("parquet")) {
            return DataSetLoader.parquet(path);
        }
        if (type.equals("json")) {
            return DataSetLoader.json(path);
        }
        if (type.equals("orc")) {
            return DataSetLoader.orc(path);
        }
        return DataSetLoader.load(type, path);
    }

    public static Dataset<Row> load(@NotNull String format, Boolean relativePath, @NotNull String path, Boolean header, String sep) {
        SparkSession session = SparkContextBuilder.getSession();
        DataFrameReader reader = session.read();
        String datasetPath = path;
        if (relativePath.booleanValue()) {
            String datasetHome;
            Long userId = Long.parseLong(Cache.getCache("userId").toString());
            Map<String, String> settings = DataSetLoader.a(userId);
            String storeHome = settings.get("store.path");
            String string = datasetPath = path.startsWith(DataSetLoader.a(storeHome, datasetHome = settings.get("store.dataset"))) ? path : DataSetLoader.a(DataSetLoader.a(storeHome, datasetHome), path);
        }
        if (format.equals("csv")) {
            if (sep == null || sep.isEmpty()) {
                sep = ",";
            }
            return a.a(datasetPath, header, sep);
        }
        return reader.format(format).load(datasetPath);
    }

    public static String getDataPath(@NotNull String path) {
        String datasetHome;
        Long userId = Long.parseLong(Cache.getCache("userId").toString());
        Map<String, String> settings = DataSetLoader.a(userId);
        String storeHome = settings.get("store.path");
        String datasetPath = path.startsWith(DataSetLoader.a(storeHome, datasetHome = settings.get("store.dataset"))) ? path : DataSetLoader.a(DataSetLoader.a(storeHome, datasetHome), path);
        return datasetPath;
    }

    public static Dataset<Row> load(@NotNull String format, @NotNull String path) {
        return DataSetLoader.load(format, true, path, null, null);
    }

    public static Dataset<Row> text(String path) {
        String[] paths = path.split(LINE_SEPARATOR);
        return DataSetLoader.text(paths);
    }

    public static Dataset<Row> text(String[] paths) {
        SparkSession session = SparkContextBuilder.getSession();
        return session.read().text(paths);
    }

    public static Dataset<Row> parquet(String path) {
        String[] paths = path.split(LINE_SEPARATOR);
        return DataSetLoader.parquet(paths);
    }

    public static Dataset<Row> parquet(String[] paths) {
        SparkSession session = SparkContextBuilder.getSession();
        return session.read().parquet(paths);
    }

    public static Dataset<Row> csv(String path) {
        String[] paths = path.split(LINE_SEPARATOR);
        return DataSetLoader.csv(paths);
    }

    public static Dataset<Row> csv(String[] paths) {
        SparkSession session = SparkContextBuilder.getSession();
        return session.read().csv(paths);
    }

    public static Dataset<Row> json(String path) {
        String[] paths = path.split(LINE_SEPARATOR);
        return DataSetLoader.json(paths);
    }

    public static Dataset<Row> json(String[] paths) {
        SparkSession session = SparkContextBuilder.getSession();
        return session.read().json(paths);
    }

    public static Dataset<Row> orc(String path) {
        String[] paths = path.split(LINE_SEPARATOR);
        return DataSetLoader.orc(paths);
    }

    public static Dataset<Row> orc(String[] paths) {
        SparkSession session = SparkContextBuilder.getSession();
        return session.read().orc(paths);
    }

    public static Dataset<Row> jdbc(String dbsource, String table) {
        SparkSession session = SparkContextBuilder.getSession();
        DBSource source = DataSetLoader.a(dbsource);
        Properties properties = new Properties();
        if (source != null) {
            properties.put("driver", source.getDriver());
            properties.put("user", source.getUser());
            properties.put("password", source.getPassword());
        }
        return session.read().jdbc(source.getUrl(), table, properties);
    }

    public static Dataset<Row> jdbc(String dbsource, String table, String columnName, long lowerBound, long upperBound, int numPartitions) {
        SparkSession session = SparkContextBuilder.getSession();
        DBSource source = DataSetLoader.a(dbsource);
        Properties properties = new Properties();
        if (source != null) {
            properties.put("driver", source.getDriver());
            properties.put("user", source.getUser());
            properties.put("password", source.getPassword());
        }
        return session.read().jdbc(source.getUrl(), table, properties);
    }

    private static DBSource a(String id) {
        List dbSourceList = (List)Cache.getCache("dbsources");
        if (dbSourceList != null) {
            return dbSourceList.stream().filter(d2 -> (long)d2.getId() == Long.parseLong(id)).findFirst().orElse(null);
        }
        return null;
    }

    private static Map<String, String> a(Long userId) {
        Object result = PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "getSystemSettings", new String[]{Long.class.getTypeName()}, new Object[]{userId});
        return (Map)result;
    }

    private static String a(String storeHome, String storePath) {
        if (storeHome.toLowerCase().startsWith("hdfs://")) {
            if (storeHome.endsWith("/") && storePath.startsWith("/")) {
                return storeHome + storePath.substring(1);
            }
            if (!storeHome.endsWith("/") && !storePath.startsWith("/")) {
                return storeHome + "/" + storePath;
            }
            return storeHome + storePath;
        }
        return Paths.get(storeHome, storePath).toString();
    }
}

