/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.data.dataset;

import com.datastax.insight.ml.spark.data.dataset.Transformal;
import com.datastax.insight.spec.Operator;
import com.google.common.base.Strings;
import java.util.Map;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import scala.Tuple2;

public class DataSetTransformation
implements Operator {
    public static <T> Dataset<Row> join(Dataset<T> left, Dataset<T> right, Column joinExprs, String joinType) {
        return left.join(right, joinExprs, joinType);
    }

    public static <T> Dataset<Row> join(Dataset<T> left, Dataset<T> right, String keyLeft, String keyRight, String joinType) {
        return left.join(right, functions.col((String)keyLeft).equalTo((Object)functions.col((String)keyRight)), joinType);
    }

    public static <T, U> Dataset<Tuple2<T, U>> joinWith(Dataset<T> left, Dataset<U> right, Column joinExprs, String joinType) {
        return left.joinWith(right, joinExprs, joinType);
    }

    public static <T> Dataset<T>[] split(Dataset<T> dataSet, double[] weights) {
        return dataSet.randomSplit(weights);
    }

    public static <T> Dataset<T> union(Dataset<T> ds1, Dataset<T> ds2) {
        return ds1.union(ds2);
    }

    public static <T, U> Dataset<U> as(Dataset<T> dataset, Encoder<U> u2) {
        return dataset.as(u2);
    }

    @Transformal
    public static <T> Dataset<T> alias(Dataset<T> dataset, String alias) {
        return dataset.as(alias);
    }

    public static <T> Dataset<T> sort(Dataset<T> dataset, String col, String ... cols) {
        return dataset.sort(col, cols);
    }

    @Transformal
    public static <T> Dataset<T> sort(Dataset<T> dataset, String col, String cols) {
        String[] columns = cols.split(";");
        return dataset.sort(col, columns);
    }

    public static <T> Dataset<T> sortWithinPartitions(Dataset<T> dataset, String col, String ... cols) {
        return dataset.sortWithinPartitions(col, cols);
    }

    @Transformal
    public static <T> Dataset<T> sortWithinPartitions(Dataset<T> dataset, String col, String cols) {
        String[] columns = cols.split(";");
        return dataset.sortWithinPartitions(col, columns);
    }

    public static <T> Dataset<T> orderBy(Dataset<T> dataset, String col, String ... cols) {
        return dataset.orderBy(col, cols);
    }

    @Transformal
    public static <T> Dataset<T> orderBy(Dataset<T> dataset, String col, String cols) {
        String[] columns = cols.split(";");
        return dataset.orderBy(col, columns);
    }

    @Transformal
    public static <T> Dataset<Row> select(Dataset<T> dataset, String col, String cols) {
        String[] columns = cols.split(";");
        return dataset.select(col, columns);
    }

    public static <T> Dataset<Row> select(Dataset<T> dataset, String col, String ... cols) {
        return dataset.select(col, cols);
    }

    public static <T> Dataset<Row> select(Dataset<T> dataset, String ... exprs) {
        return dataset.selectExpr(exprs);
    }

    @Transformal
    public static <T> Dataset<Row> select(Dataset<T> dataset, String exprs) {
        String[] expressions = exprs.split(";");
        return dataset.selectExpr(expressions);
    }

    @Transformal
    public static <T> Dataset<T> filter(Dataset<T> dataset, String expr) {
        return dataset.filter(expr);
    }

    @Transformal
    public static <T> Dataset<T> where(Dataset<T> dataset, String expr) {
        return dataset.where(expr);
    }

    public static <T> Dataset<Row> agg(Dataset<T> dataset, Map<String, String> map) {
        return dataset.agg(map);
    }

    @Transformal
    public static <T> Dataset<T> limit(Dataset<T> dataset, int n2) {
        return dataset.limit(n2);
    }

    public static <T> Dataset<T> intersect(Dataset<T> dataset1, Dataset<T> dataset2) {
        return dataset1.intersect(dataset2);
    }

    public static <T> Dataset<T> except(Dataset<T> dataset1, Dataset<T> dataset2) {
        return dataset1.except(dataset2);
    }

    @Transformal
    public static <T> Dataset<Row> withColumnRenamed(Dataset<T> dataset, String existingName, String newName) {
        return dataset.withColumnRenamed(existingName, newName);
    }

    public static <T> Dataset<Row> drop(Dataset<T> dataset, String ... cols) {
        return dataset.drop(cols);
    }

    @Transformal
    public static <T> Dataset<T> dropDuplicates(Dataset<T> dataset) {
        return dataset.dropDuplicates();
    }

    @Transformal
    public static <T> Dataset<T> dropDuplicates(Dataset<T> dataset, String cols) {
        if (!Strings.isNullOrEmpty((String)cols)) {
            String[] columns = cols.split(";");
            return dataset.dropDuplicates(columns);
        }
        return dataset.dropDuplicates();
    }

    public static <T, U> Dataset<U> map(Dataset<T> dataset, MapFunction<T, U> func, Encoder<U> u2) {
        return dataset.map(func, u2);
    }

    public static <T, U> Dataset<U> mapPartitions(Dataset<T> dataset, MapPartitionsFunction<T, U> func, Encoder<U> u2) {
        return dataset.mapPartitions(func, u2);
    }

    public static <T, U> Dataset<U> flatMap(Dataset<T> dataset, FlatMapFunction<T, U> func, Encoder<U> u2) {
        return dataset.flatMap(func, u2);
    }

    @Transformal
    public static <T> Dataset<T> repartition(Dataset<T> dataset, int n2) {
        return dataset.repartition(n2);
    }

    @Transformal
    public static <T> Dataset<T> coalesce(Dataset<T> dataset, int n2) {
        return dataset.coalesce(n2);
    }

    @Transformal
    public static <T> JavaRDD<T> toJavaRDD(Dataset<T> dataset) {
        return dataset.toJavaRDD();
    }

    @Transformal
    public static <T> Dataset<String> toJSON(Dataset<T> dataset) {
        return dataset.toJSON();
    }

    @Transformal
    public static <T> Dataset<Row> toDF(Dataset<T> dataset) {
        return dataset.toDF();
    }

    public static <T> Dataset<Row> toDF(Dataset<T> dataset, String[] cols) {
        return dataset.toDF(cols);
    }

    @Transformal
    public static <T> Dataset<Row> toDF(Dataset<T> dataset, String cols) {
        String[] columns = cols.split(";");
        return dataset.toDF(columns);
    }

    @Deprecated
    public static <T> Dataset<Row> cast(Dataset<T> dataset, String column, String type) {
        String[] columns = column.split(";");
        Dataset result = null;
        for (String c2 : columns) {
            result = result == null ? dataset.withColumn(c2, dataset.col(c2).cast(type)) : result.withColumn(c2, dataset.col(c2).cast(type));
        }
        return result == null ? dataset.toDF() : result;
    }

    public static void show(Dataset data, Integer numRows, Integer truncate) {
        if (numRows == null) {
            data.show();
        } else if (truncate == null) {
            data.show(numRows.intValue());
        } else {
            data.show(numRows.intValue(), truncate.intValue());
        }
    }
}

