/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.data.dataset;

import com.datastax.insight.core.entity.Cache;
import com.datastax.insight.core.entity.DBSource;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.Operator;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;

public class DataSetWriter
implements Operator {
    public static <T> void save(Dataset<T> dataset, String format, String mode, String path) throws Exception {
        DataSetWriter.save(dataset, format, mode, path, true);
    }

    public static <T> void save(Dataset<T> dataset, String format, String mode, String path, boolean withHeader) throws Exception {
        Configuration conf = new Configuration();
        FileSystem hdfs = FileSystem.get((URI)new URI(path), (Configuration)conf);
        String temp = new Path(hdfs.getWorkingDirectory(), "temp_" + String.valueOf(System.currentTimeMillis())).toString();
        DataFrameWriter writer = dataset.write();
        if (withHeader) {
            writer.option("header", true);
        }
        writer.format(format).mode(mode).save(temp);
        if (hdfs.exists(new Path(path))) {
            hdfs.delete(new Path(path), true);
        }
        FileUtil.copyMerge((FileSystem)hdfs, (Path)new Path(temp), (FileSystem)hdfs, (Path)new Path(path), (boolean)true, (Configuration)conf, null);
        PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "saveFlowResult", new String[]{Long.class.getTypeName(), String.class.getTypeName()}, new Object[]{PersistService.getFlowId(), path});
    }

    public static <T> void write(Dataset<T> dataset, String format, String mode, String path, boolean withHeader) throws Exception {
        DataFrameWriter writer = dataset.write();
        if (withHeader) {
            writer.option("header", true);
        }
        writer.format(format).mode(mode).save(path);
    }

    public static <T> void jdbc(Dataset<T> dataset, String mode, DBSource dbSource, String table) {
        if (dbSource != null) {
            Properties properties = new Properties();
            properties.put("driver", dbSource.getDriver());
            properties.put("user", dbSource.getUser());
            properties.put("password", dbSource.getPassword());
            dataset.write().mode(mode).jdbc(dbSource.getUrl(), table, properties);
        }
    }

    public static <T> void jdbc(Dataset<T> dataset, String mode, String dbID, String table) {
        DBSource dbSource = DataSetWriter.a(dbID);
        DataSetWriter.jdbc(dataset, mode, dbSource, table);
    }

    private static DBSource a(String id) {
        List dbSourceList = (List)Cache.getCache("dbsources");
        if (dbSourceList != null) {
            return dbSourceList.stream().filter(d2 -> d2.getId() == Integer.parseInt(id)).findFirst().orElse(null);
        }
        return null;
    }
}

