/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.data.dataset;

import com.datastax.insight.ml.spark.data.dataset.Transformal;
import com.datastax.insight.spec.Operator;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;

class DatasetBasic
implements Operator {
    DatasetBasic() {
    }

    @Transformal
    public static Dataset<Row> toDF(Dataset data, @Nullable String cols) {
        if (Strings.isNullOrEmpty((String)cols)) {
            return data.toDF();
        }
        String[] columns = cols.split(";");
        return data.toDF(columns);
    }

    public StructType schema(Dataset data) {
        return data.schema();
    }

    public static void printSchema(Dataset data) {
        data.printSchema();
    }

    public static void explain(Dataset data, Boolean extended) {
        if (extended == null) {
            data.explain();
        } else {
            data.explain(extended.booleanValue());
        }
    }

    public static Map<String, String> dtypes(Dataset data) {
        return Arrays.stream(data.dtypes()).collect(HashMap::new, (mapping, info) -> mapping.put(info._1.toString(), info._2.toString()), HashMap::putAll);
    }

    public static String[] columns(Dataset data) {
        return data.columns();
    }

    public static boolean isLocal(Dataset data) {
        return data.isLocal();
    }

    public static <T> Dataset<T> checkpoint(Dataset<T> data, Boolean eager) {
        return eager == null ? data.checkpoint() : data.checkpoint(eager.booleanValue());
    }

    public static Dataset persist(Dataset data, String storageLevel) {
        return Strings.isNullOrEmpty((String)storageLevel) ? data.persist() : data.persist(StorageLevel.fromString((String)storageLevel));
    }

    public static Dataset unpersist(Dataset data, Boolean blocking) {
        return blocking == null ? data.unpersist() : data.unpersist(blocking.booleanValue());
    }

    public static <T> RDD<T> rdd(Dataset<T> data) {
        return data.rdd();
    }

    public static <T> JavaRDD<T> javaRDD(Dataset<T> data) {
        return data.javaRDD();
    }

    public static void createTempViewCommand(Dataset data, String viewName, Boolean replace, Boolean global) throws AnalysisException {
        if (replace == null || !replace.booleanValue()) {
            if (global == null || !global.booleanValue()) {
                data.createTempView(viewName);
            } else {
                data.createGlobalTempView(viewName);
            }
        } else if (global == null || !global.booleanValue()) {
            data.createOrReplaceTempView(viewName);
        }
    }

    public static <T> Dataset<String> persist(Dataset<T> data) {
        return data.toJSON();
    }

    public static <T> String[] inputFiles(Dataset<T> data) {
        return data.inputFiles();
    }
}

