/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.data.rdd;

import com.datastax.insight.spec.RDDOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;

public class RDDTransformation
implements RDDOperator {
    public static JavaRDD<Vector> denseVector(JavaRDD<String> rdd, String delimiter) {
        JavaRDD vectors = rdd.map((Function & Serializable)s2 -> {
            String delim = delimiter;
            if (delim == null || delim.length() == 0) {
                delim = ";";
            }
            String[] sarray = s2.split(delim);
            double[] values = new double[sarray.length];
            for (int i2 = 0; i2 < sarray.length; ++i2) {
                values[i2] = Double.parseDouble(sarray[i2]);
            }
            return Vectors.dense((double[])values);
        });
        return vectors;
    }

    public static JavaRDD<LabeledPoint> lpRDD(JavaRDD<String> rdd, String delimiter) {
        JavaRDD labeledPoints = rdd.map((Function & Serializable)s2 -> {
            String delim = delimiter;
            if (delim == null || delim.length() == 0) {
                delim = ";";
            }
            String[] sarray = s2.split(delim);
            double[] values = new double[sarray.length];
            for (int i2 = 1; i2 < sarray.length; ++i2) {
                values[i2] = Double.parseDouble(sarray[i2]);
            }
            return new LabeledPoint(Double.parseDouble(sarray[0]), Vectors.dense((double[])values));
        });
        return labeledPoints;
    }

    public static JavaRDD<LabeledPoint>[] split(JavaRDD<LabeledPoint> data, String weights) {
        String[] texts = weights.split(";");
        double[] ws = new double[texts.length];
        for (int i2 = 0; i2 < ws.length; ++i2) {
            ws[i2] = Double.parseDouble(texts[i2]);
        }
        return data.randomSplit(ws);
    }

    public static <T> JavaRDD<T> distinct(JavaRDD<T> rdd, int numPartitions) {
        if (numPartitions > 0) {
            return rdd.distinct(numPartitions);
        }
        return rdd.distinct();
    }

    public static <T> JavaRDD<T> coalesce(JavaRDD<T> rdd, int numPartitions, boolean shuffle) {
        return rdd.coalesce(numPartitions, shuffle);
    }

    public static <T> JavaRDD<T> repartition(JavaRDD<T> rdd, int numPartitions) {
        return rdd.repartition(numPartitions);
    }

    public static <T> JavaRDD<T> sample(JavaRDD<T> rdd, boolean withReplacement, double fraction, long seed) {
        return rdd.sample(withReplacement, fraction, seed);
    }

    public static <T> JavaRDD<T> union(JavaRDD<T> rdd, JavaRDD<T> other) {
        return rdd.union(other);
    }

    public static <T> JavaRDD<T> intersection(JavaRDD<T> rdd, JavaRDD<T> other) {
        return rdd.intersection(other);
    }

    public static <T> JavaRDD<T> subtract(JavaRDD<T> rdd, JavaRDD<T> other, int numPartitions) {
        return rdd.subtract(other, numPartitions);
    }

    public static <T> JavaRDD<T> setName(JavaRDD<T> rdd, String name) {
        return rdd.setName(name);
    }

    public static <T> JavaRDD<List<T>> glom(JavaRDD<T> rdd) {
        return rdd.glom();
    }

    public static JavaRDD<String> pipe(JavaRDD<String> rdd, String ... command) {
        ArrayList<String> list = new ArrayList<String>();
        for (String c2 : command) {
            list.add(c2);
        }
        return rdd.pipe(list);
    }

    public static <T> JavaPairRDD<T, Long> zip(JavaRDD<T> rdd, String type) {
        if (type.equals("uniqueid")) {
            return rdd.zipWithUniqueId();
        }
        if (type.equals("index")) {
            return rdd.zipWithIndex();
        }
        return null;
    }

    public static <T> List<T> collect(JavaRDD<T> rdd) {
        return rdd.collect();
    }

    public static <T> List<T>[] collectPartitions(JavaRDD<T> rdd, String pid) {
        String[] pids = pid.split(";");
        int[] partitionIds = new int[pids.length];
        for (int i2 = 0; i2 < pids.length; ++i2) {
            partitionIds[i2] = Integer.parseInt(pids[i2]);
        }
        return rdd.collectPartitions(partitionIds);
    }

    public static <T> Object count(JavaRDD<T> rdd, boolean byValue, long timeout, double confidence) {
        if (byValue) {
            if (timeout > 0L) {
                return rdd.countByValueApprox(timeout, confidence);
            }
            return rdd.countByValue();
        }
        if (timeout > 0L) {
            return rdd.countApprox(timeout, confidence);
        }
        return rdd.count();
    }

    public static <T> List<T> take(JavaRDD<T> rdd, int num) {
        return rdd.take(num);
    }

    public static <T> List<T> takeOrdered(JavaRDD<T> rdd, int num) {
        return rdd.takeOrdered(num);
    }

    public static <T> List<T> top(JavaRDD<T> rdd, int num) {
        return rdd.top(num);
    }

    public static <T> List<T> takeSample(JavaRDD<T> rdd, boolean withReplacement, int num, long seed) {
        return rdd.takeSample(withReplacement, num, seed);
    }

    public static <T> T first(JavaRDD<T> rdd) {
        return (T)rdd.first();
    }
}

