/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.classification;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class DecisionTreeClassifierWrapper
implements DataSetOperator {
    public static DecisionTreeClassifier getOperator(String labelCol, String featuresCol, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity) {
        DecisionTreeClassifier classifier = new DecisionTreeClassifier();
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            classifier.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            classifier.setFeaturesCol(featuresCol);
        }
        if (maxDepth != null) {
            classifier.setMaxDepth(maxDepth.intValue());
        }
        if (maxBins != null) {
            classifier.setMaxBins(maxBins.intValue());
        }
        if (minInstancesPerNode != null) {
            classifier.setMinInstancesPerNode(minInstancesPerNode.intValue());
        }
        if (minInfoGain != null) {
            classifier.setMinInfoGain(minInfoGain.doubleValue());
        }
        if (maxMemoryInMB != null) {
            classifier.setMaxMemoryInMB(maxMemoryInMB.intValue());
        }
        if (cacheNodeIds != null) {
            classifier.setCacheNodeIds(cacheNodeIds.booleanValue());
        }
        if (checkpointInterval != null) {
            classifier.setCheckpointInterval(checkpointInterval.intValue());
        }
        if (!Strings.isNullOrEmpty((String)impurity)) {
            classifier.setImpurity(impurity);
        }
        return classifier;
    }

    public static DecisionTreeClassificationModel fit(Dataset<Row> data, String labelCol, String featuresCol, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity) {
        DecisionTreeClassifier classifier = DecisionTreeClassifierWrapper.getOperator(labelCol, featuresCol, maxDepth, maxBins, minInstancesPerNode, minInfoGain, maxMemoryInMB, cacheNodeIds, checkpointInterval, impurity);
        return (DecisionTreeClassificationModel)classifier.fit(data);
    }

    public static DecisionTreeClassificationModel fit(DecisionTreeClassifier classifier, Dataset<Row> data) {
        return (DecisionTreeClassificationModel)classifier.fit(data);
    }

    public static Dataset<Row> transform(DecisionTreeClassificationModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

