/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.classification;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.classification.LinearSVC;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.sql.Dataset;

public class LinearSVCWrapper
implements DataSetOperator {
    public static LinearSVC getOperator(Integer aggregationDepth, Boolean fitIntercept, Integer maxIter, Double regParam, Boolean standardization, Double threshold, Double tol, String weightCol, String featuresCol, String labelCol, String predictionCol) {
        LinearSVC classifier = new LinearSVC();
        if (aggregationDepth != null) {
            classifier.setAggregationDepth(aggregationDepth.intValue());
        }
        if (fitIntercept != null) {
            classifier.setFitIntercept(fitIntercept.booleanValue());
        }
        if (maxIter != null) {
            classifier.setMaxIter(maxIter.intValue());
        }
        if (regParam != null) {
            classifier.setRegParam(regParam.doubleValue());
        }
        if (standardization != null) {
            classifier.setStandardization(standardization.booleanValue());
        }
        if (threshold != null) {
            classifier.setThreshold(threshold.doubleValue());
        }
        if (tol != null) {
            classifier.setTol(tol.doubleValue());
        }
        if (!Strings.isNullOrEmpty((String)weightCol)) {
            classifier.setWeightCol(weightCol);
        }
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            classifier.setFeaturesCol(featuresCol);
        }
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            classifier.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)predictionCol)) {
            classifier.setPredictionCol(predictionCol);
        }
        return classifier;
    }

    public static LinearSVCModel fit(LinearSVC classifier, Dataset dataset) {
        return (LinearSVCModel)classifier.fit(dataset);
    }

    public static Dataset transform(LinearSVCModel model, Dataset dataset) {
        return model.transform(dataset);
    }
}

