/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.classification;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class LogisticRegressionWrapper
implements DataSetOperator {
    public static LogisticRegression getOperator(String featuresCol, String labelCol, Integer maxIterations, Double regParam, Double elasticNetParam, Double threshold, Double tol, Boolean fitIntercept, Boolean standardization, String weightCol) {
        LogisticRegression classifier = new LogisticRegression();
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            classifier.setFeaturesCol(featuresCol);
        }
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            classifier.setLabelCol(labelCol);
        }
        if (maxIterations != null) {
            classifier.setMaxIter(maxIterations.intValue());
        }
        if (regParam != null) {
            classifier.setRegParam(regParam.doubleValue());
        }
        if (elasticNetParam != null) {
            classifier.setElasticNetParam(elasticNetParam.doubleValue());
        }
        if (threshold != null) {
            classifier.setThreshold(threshold.doubleValue());
        }
        if (fitIntercept != null) {
            classifier.setFitIntercept(fitIntercept.booleanValue());
        }
        if (tol != null) {
            classifier.setTol(tol.doubleValue());
        }
        if (standardization != null) {
            classifier.setStandardization(standardization.booleanValue());
        }
        if (!Strings.isNullOrEmpty((String)weightCol)) {
            classifier.setWeightCol(weightCol);
        }
        return classifier;
    }

    public static LogisticRegressionModel fit(Dataset<Row> data, String featuresCol, String labelCol, Integer maxIterations, Double regParam, Double elasticNetParam, Double threshold, Double tol, Boolean fitIntercept, Boolean standardization, String weightCol) {
        LogisticRegression regression = LogisticRegressionWrapper.getOperator(featuresCol, labelCol, maxIterations, regParam, elasticNetParam, threshold, tol, fitIntercept, standardization, weightCol);
        return (LogisticRegressionModel)regression.fit(data);
    }

    public static LogisticRegressionModel fit(LogisticRegression regression, Dataset<Row> data) {
        return (LogisticRegressionModel)regression.fit(data);
    }

    public static Dataset<Row> transform(LogisticRegressionModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

