/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.classification;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class MultilayerPerceptronClassifierWrapper
implements DataSetOperator {
    public static MultilayerPerceptronClassifier getOperator(String featuresCol, String labelCol, String layer, Integer blockSize, Long seed, Integer maxIterations, Double tol, Double stepSize, String solver) {
        MultilayerPerceptronClassifier classifier = new MultilayerPerceptronClassifier();
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            classifier.setFeaturesCol(featuresCol);
        }
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            classifier.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)layer)) {
            String[] ls = layer.split(";");
            int[] layers = new int[ls.length];
            for (int i2 = 0; i2 < layers.length; ++i2) {
                layers[i2] = Integer.parseInt(ls[i2]);
            }
            classifier.setLayers(layers);
        }
        if (blockSize != null) {
            classifier.setBlockSize(blockSize.intValue());
        }
        if (seed != null) {
            classifier.setSeed(seed.longValue());
        }
        if (maxIterations != null) {
            classifier.setMaxIter(maxIterations.intValue());
        }
        if (tol != null) {
            classifier.setTol(tol.doubleValue());
        }
        if (stepSize != null) {
            classifier.setStepSize(stepSize.doubleValue());
        }
        if (!Strings.isNullOrEmpty((String)solver)) {
            classifier.setSolver(solver);
        }
        return classifier;
    }

    public static MultilayerPerceptronClassificationModel fit(Dataset<Row> data, String featuresCol, String labelCol, String layer, Integer blockSize, Long seed, Integer maxIterations, Double tol, Double stepSize, String solver) {
        MultilayerPerceptronClassifier classifier = MultilayerPerceptronClassifierWrapper.getOperator(featuresCol, labelCol, layer, blockSize, seed, maxIterations, tol, stepSize, solver);
        return (MultilayerPerceptronClassificationModel)classifier.fit(data);
    }

    public static MultilayerPerceptronClassificationModel fit(MultilayerPerceptronClassifier classifier, Dataset<Row> data) {
        return (MultilayerPerceptronClassificationModel)classifier.fit(data);
    }

    public static Dataset<Row> transform(MultilayerPerceptronClassificationModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

