/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.classification;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class NaiveBayesClassifier
implements DataSetOperator {
    public static NaiveBayes getOperator(String featuresCol, String labelCol, Double smoothing, String modelType) {
        NaiveBayes classifier = new NaiveBayes();
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            classifier.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            classifier.setFeaturesCol(featuresCol);
        }
        if (smoothing != null) {
            classifier.setSmoothing(smoothing.doubleValue());
        }
        if (!Strings.isNullOrEmpty((String)modelType)) {
            classifier.setModelType(modelType);
        }
        return classifier;
    }

    public static NaiveBayesModel fit(Dataset<Row> data, String featuresCol, String labelCol, Double smoothing, String modelType) {
        NaiveBayes naiveBayes = NaiveBayesClassifier.getOperator(featuresCol, labelCol, smoothing, modelType);
        return (NaiveBayesModel)naiveBayes.fit(data);
    }

    public static NaiveBayesModel fit(NaiveBayes naiveBayes, Dataset<Row> data) {
        return (NaiveBayesModel)naiveBayes.fit(data);
    }

    public static Dataset<Row> transform(NaiveBayesModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

