/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.classification;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class RandomForestClassifierWrapper
implements DataSetOperator {
    public static RandomForestClassifier getOperator(String labelCol, String featuresCol, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity, Double subsamplingRate, Integer numTrees, String featureSubsetStrategy) {
        RandomForestClassifier classifier = new RandomForestClassifier();
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            classifier.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            classifier.setFeaturesCol(featuresCol);
        }
        if (maxDepth != null) {
            classifier.setMaxDepth(maxDepth.intValue());
        }
        if (maxBins != null) {
            classifier.setMaxBins(maxBins.intValue());
        }
        if (minInstancesPerNode != null) {
            classifier.setMinInstancesPerNode(minInstancesPerNode.intValue());
        }
        if (minInfoGain != null) {
            classifier.setMinInfoGain(minInfoGain.doubleValue());
        }
        if (maxMemoryInMB != null) {
            classifier.setMaxMemoryInMB(maxMemoryInMB.intValue());
        }
        if (cacheNodeIds != null) {
            classifier.setCacheNodeIds(cacheNodeIds.booleanValue());
        }
        if (checkpointInterval != null) {
            classifier.setCheckpointInterval(checkpointInterval.intValue());
        }
        if (!Strings.isNullOrEmpty((String)impurity)) {
            classifier.setImpurity(impurity);
        }
        if (!Strings.isNullOrEmpty((String)featureSubsetStrategy)) {
            classifier.setFeatureSubsetStrategy(featureSubsetStrategy);
        }
        if (subsamplingRate != null) {
            classifier.setSubsamplingRate(subsamplingRate.doubleValue());
        }
        if (numTrees != null) {
            classifier.setNumTrees(numTrees.intValue());
        }
        return classifier;
    }

    public static RandomForestClassificationModel fit(Dataset<Row> data, String labelCol, String featuresCol, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity, Double subsamplingRate, Integer numTrees, String featureSubsetStrategy) {
        RandomForestClassifier classifier = RandomForestClassifierWrapper.getOperator(labelCol, featuresCol, maxDepth, maxBins, minInstancesPerNode, minInfoGain, maxMemoryInMB, cacheNodeIds, checkpointInterval, impurity, subsamplingRate, numTrees, featureSubsetStrategy);
        return (RandomForestClassificationModel)classifier.fit(data);
    }

    public static RandomForestClassificationModel fit(RandomForestClassifier classifier, Dataset<Row> data) {
        return (RandomForestClassificationModel)classifier.fit(data);
    }

    public static Dataset<Row> transform(RandomForestClassificationModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

