/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.cluster;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.clustering.BisectingKMeans;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class BisectingKMeansHandler
implements DataSetOperator {
    public static BisectingKMeans getOperator(String featuresCol, Integer k2, Integer maxIterations, Long seed, Double minDivisibleClusterSize) {
        BisectingKMeans kMeans = new BisectingKMeans();
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            kMeans.setFeaturesCol(featuresCol);
        }
        if (k2 != null) {
            kMeans.setK(k2.intValue());
        }
        if (maxIterations != null) {
            kMeans.setMaxIter(maxIterations.intValue());
        }
        if (seed != null) {
            kMeans.setSeed(seed.longValue());
        }
        if (minDivisibleClusterSize != null) {
            kMeans.setMinDivisibleClusterSize(minDivisibleClusterSize.doubleValue());
        }
        return kMeans;
    }

    public static BisectingKMeansModel fit(Dataset<Row> data, String featuresCol, Integer k2, Integer maxIterations, Long seed, Double minDivisibleClusterSize) {
        BisectingKMeans kMeans = BisectingKMeansHandler.getOperator(featuresCol, k2, maxIterations, seed, minDivisibleClusterSize);
        return kMeans.fit(data);
    }

    public static BisectingKMeansModel fit(BisectingKMeans kMeans, Dataset<Row> data) {
        return kMeans.fit(data);
    }

    public static Dataset<Row> transform(BisectingKMeansModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

