/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.cluster;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.clustering.GaussianMixture;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class GaussianMixturer
implements DataSetOperator {
    public static GaussianMixture getOperator(String featuresCol, Integer k2, Integer maxIterations, Double tol, Long seed) {
        GaussianMixture gussian = new GaussianMixture();
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            gussian.setFeaturesCol(featuresCol);
        }
        if (k2 != null) {
            gussian.setK(k2.intValue());
        }
        if (maxIterations != null) {
            gussian.setMaxIter(maxIterations.intValue());
        }
        if (tol != null) {
            gussian.setTol(tol.doubleValue());
        }
        if (seed != null) {
            gussian.setSeed(seed.longValue());
        }
        return gussian;
    }

    public static GaussianMixtureModel fit(Dataset<Row> data, String featuresCol, Integer k2, Integer maxIterations, Double tol, Long seed) {
        GaussianMixture gussian = GaussianMixturer.getOperator(featuresCol, k2, maxIterations, tol, seed);
        return gussian.fit(data);
    }

    public static GaussianMixtureModel fit(GaussianMixture gussian, Dataset<Row> data) {
        return gussian.fit(data);
    }

    public static Dataset<Row> transform(GaussianMixtureModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

