/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.cluster;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.clustering.LDA;
import org.apache.spark.ml.clustering.LDAModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class LDACluster
implements DataSetOperator {
    public static LDA getOperator(String featuresCol, Integer k2, Integer maxIterations, Long seed, Integer checkpointInterval, String docConcentration, Double topicConcentration, String optimizer, String topicDistributionCol, Double learningOffset, Double learningDecay, Double subsamplingRate, Boolean optimizeDocConcentration, Boolean keepLastCheckpoint) {
        LDA lda = new LDA();
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            lda.setFeaturesCol(featuresCol);
        }
        if (k2 != null) {
            lda.setK(k2.intValue());
        }
        if (maxIterations != null) {
            lda.setMaxIter(maxIterations.intValue());
        }
        if (seed != null) {
            lda.setSeed(seed.longValue());
        }
        if (checkpointInterval != null) {
            lda.setCheckpointInterval(checkpointInterval.intValue());
        }
        if (!Strings.isNullOrEmpty((String)docConcentration)) {
            String[] dcs = docConcentration.split(";");
            double[] dc = new double[dcs.length];
            for (int i2 = 0; i2 < dc.length; ++i2) {
                dc[i2] = Double.parseDouble(dcs[i2]);
            }
            lda.setDocConcentration(dc);
        }
        if (topicConcentration != null) {
            lda.setTopicConcentration(topicConcentration.doubleValue());
        }
        if (!Strings.isNullOrEmpty((String)optimizer)) {
            lda.setOptimizer(optimizer);
        }
        if (!Strings.isNullOrEmpty((String)topicDistributionCol)) {
            lda.setTopicDistributionCol(topicDistributionCol);
        }
        if (learningOffset != null) {
            lda.setLearningOffset(learningOffset.doubleValue());
        }
        if (learningDecay != null) {
            lda.setLearningDecay(learningDecay.doubleValue());
        }
        if (subsamplingRate != null) {
            lda.setSubsamplingRate(subsamplingRate.doubleValue());
        }
        if (optimizeDocConcentration != null) {
            lda.setOptimizeDocConcentration(optimizeDocConcentration.booleanValue());
        }
        if (keepLastCheckpoint != null) {
            lda.setKeepLastCheckpoint(keepLastCheckpoint.booleanValue());
        }
        return lda;
    }

    public static LDAModel fit(Dataset<Row> data, String featuresCol, Integer k2, Integer maxIterations, Long seed, Integer checkpointInterval, String docConcentration, Double topicConcentration, String optimizer, String topicDistributionCol, Double learningOffset, Double learningDecay, Double subsamplingRate, Boolean optimizeDocConcentration, Boolean keepLastCheckpoint) {
        LDA lda = LDACluster.getOperator(featuresCol, k2, maxIterations, seed, checkpointInterval, docConcentration, topicConcentration, optimizer, topicDistributionCol, learningOffset, learningDecay, subsamplingRate, optimizeDocConcentration, keepLastCheckpoint);
        return lda.fit(data);
    }

    public static LDAModel fit(LDA lda, Dataset<Row> data) {
        return lda.fit(data);
    }

    public static Dataset<Row> transform(LDAModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

