/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.cluster;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SimpleKMeans
implements DataSetOperator {
    public static KMeans getOperator(String featuresCol, Integer k2, Integer maxIterations, String initMode, Integer initSteps, Double tol, Long seed) {
        KMeans kMeans = new KMeans();
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            kMeans.setFeaturesCol(featuresCol);
        }
        if (k2 != null) {
            kMeans.setK(k2.intValue());
        }
        if (maxIterations != null) {
            kMeans.setMaxIter(maxIterations.intValue());
        }
        if (!Strings.isNullOrEmpty((String)initMode)) {
            kMeans.setInitMode(initMode);
        }
        if (initSteps != null) {
            kMeans.setInitSteps(initSteps.intValue());
        }
        if (tol != null) {
            kMeans.setTol(tol.doubleValue());
        }
        if (seed != null) {
            kMeans.setSeed(seed.longValue());
        }
        return kMeans;
    }

    public static KMeansModel fit(Dataset<Row> data, String featuresCol, Integer k2, Integer maxIterations, String initMode, Integer initSteps, Double tol, Long seed) {
        KMeans kMeans = SimpleKMeans.getOperator(featuresCol, k2, maxIterations, initMode, initSteps, tol, seed);
        return kMeans.fit(data);
    }

    public static KMeansModel fit(KMeans kMeans, Dataset<Row> data) {
        return kMeans.fit(data);
    }

    public static Dataset<Row> transform(KMeansModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

