/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.feature.selector;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.VectorSlicer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class VectorSlicerWrapper
implements DataSetOperator {
    public static VectorSlicer getOperator(String inputCol, String outputCol, String names, String indices) {
        int[] ins = null;
        if (indices != null && indices.length() > 0) {
            String[] sps = indices.split(";");
            ins = new int[sps.length];
            for (int i2 = 0; i2 < ins.length; ++i2) {
                ins[i2] = Integer.parseInt(sps[i2]);
            }
        }
        String[] ns = names.split(";");
        VectorSlicer vectorSlicer = new VectorSlicer().setInputCol(inputCol).setOutputCol(outputCol).setNames(ns);
        if (ins != null) {
            vectorSlicer.setIndices(ins);
        }
        return vectorSlicer;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol, String names, String indices) {
        VectorSlicer vectorSlicer = VectorSlicerWrapper.getOperator(inputCol, outputCol, names, indices);
        Dataset tdata = vectorSlicer.transform(data);
        return tdata;
    }

    public static Dataset<Row> transform(VectorSlicer vectorSlicer, Dataset<Row> data) {
        Dataset tdata = vectorSlicer.transform(data);
        return tdata;
    }
}

