/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class BucketizerWrapper
implements DataSetOperator {
    public static Bucketizer getOperator(String inputCol, String outputCol, String sp2, String handleInvalid) {
        double[] splits = null;
        if (sp2 != null && sp2.length() > 0) {
            String[] sps = sp2.split(";");
            splits = new double[sps.length];
            for (int i2 = 0; i2 < splits.length; ++i2) {
                splits[i2] = Double.parseDouble(sps[i2]);
            }
        }
        Bucketizer bucketizer = new Bucketizer();
        if (!Strings.isNullOrEmpty((String)inputCol)) {
            bucketizer.setInputCol(inputCol);
        }
        if (!Strings.isNullOrEmpty((String)outputCol)) {
            bucketizer.setOutputCol(outputCol);
        }
        if (!Strings.isNullOrEmpty((String)handleInvalid)) {
            bucketizer.setHandleInvalid(handleInvalid);
        }
        if (splits != null) {
            bucketizer.setSplits(ArrayUtils.add((double[])ArrayUtils.addAll((double[])new double[]{Double.NEGATIVE_INFINITY}, (double[])splits), (double)Double.POSITIVE_INFINITY));
        }
        return bucketizer;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol, String sp2, String handleInvalid) {
        Bucketizer bucketizer = BucketizerWrapper.getOperator(inputCol, outputCol, sp2, handleInvalid);
        Dataset tdata = bucketizer.transform(data);
        return tdata;
    }

    public static Dataset<Row> transform(Bucketizer bucketizer, Dataset<Row> data) {
        Dataset tdata = bucketizer.transform(data);
        return tdata;
    }
}

