/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.ElementwiseProduct;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class HadamardProduct
implements DataSetOperator {
    public static ElementwiseProduct getOperator(String inputCol, String outputCol, String vectorText) {
        double[] vectors = null;
        if (vectorText != null && vectorText.length() > 0) {
            String[] vs = vectorText.split(";");
            vectors = new double[vs.length];
            for (int i2 = 0; i2 < vectors.length; ++i2) {
                vectors[i2] = Double.parseDouble(vs[i2]);
            }
        }
        ElementwiseProduct transformer = (ElementwiseProduct)((ElementwiseProduct)new ElementwiseProduct().setInputCol(inputCol)).setOutputCol(outputCol);
        if (vectors != null) {
            transformer.setScalingVec(Vectors.dense((double[])vectors));
        }
        return transformer;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol, String vectorText) {
        ElementwiseProduct transformer = HadamardProduct.getOperator(inputCol, outputCol, vectorText);
        Dataset tdata = transformer.transform(data);
        return tdata;
    }

    public static Dataset<Row> transform(ElementwiseProduct transformer, Dataset<Row> data) {
        Dataset tdata = transformer.transform(data);
        return tdata;
    }
}

