/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class IndexToStringWrapper
implements DataSetOperator {
    public static IndexToString getOperator(String inputCol, String outputCol, String labels) {
        IndexToString labelConverter = new IndexToString().setInputCol(inputCol).setOutputCol(outputCol);
        if (!Strings.isNullOrEmpty((String)labels)) {
            String[] labelArray = labels.split(";");
            labelConverter.setLabels(labelArray);
        }
        return labelConverter;
    }

    public static IndexToString getOperator(String inputCol, String outputCol, String[] labels) {
        IndexToString labelConverter = new IndexToString().setInputCol(inputCol).setOutputCol(outputCol);
        if (labels != null) {
            labelConverter.setLabels(labels);
        }
        return labelConverter;
    }

    public static Dataset<Row> transform(IndexToString indexToString, Dataset<Row> data) {
        Dataset tdata = indexToString.transform(data);
        return tdata;
    }
}

