/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class StringIndexerWrapper
implements DataSetOperator {
    public static StringIndexer getOperator(String inputCol, String outputCol, String handleInvalid) {
        StringIndexer indexer = new StringIndexer().setInputCol(inputCol).setOutputCol(outputCol);
        if (!Strings.isNullOrEmpty((String)handleInvalid)) {
            indexer = indexer.setHandleInvalid(handleInvalid);
        }
        return indexer;
    }

    public static StringIndexerModel fit(Dataset<Row> data, String inputCol, String outputCol, String handleInvalid) {
        StringIndexer indexer = StringIndexerWrapper.getOperator(inputCol, outputCol, handleInvalid);
        StringIndexerModel model = indexer.fit(data);
        return model;
    }

    public static StringIndexerModel fit(StringIndexer indexer, Dataset<Row> data) {
        StringIndexerModel model = indexer.fit(data);
        return model;
    }

    public static Dataset<Row> transform(StringIndexerModel model, Dataset<Row> data) {
        Dataset tdata = model.transform(data);
        return tdata;
    }
}

