/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.feature.transformer;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class VectorAssemblerWrapper
implements DataSetOperator {
    public static VectorAssembler getOperator(String inputCol, String outputCol) {
        String[] inputCols = inputCol.split(";");
        VectorAssembler assembler = new VectorAssembler().setInputCols(inputCols).setOutputCol(outputCol);
        return assembler;
    }

    public static Dataset<Row> transform(Dataset<Row> data, String inputCol, String outputCol) {
        String[] columns = inputCol.split(";");
        Dataset result = null;
        for (String c2 : columns) {
            result = result == null ? data.withColumn(c2, data.col(c2).cast("double")) : result.withColumn(c2, data.col(c2).cast("double"));
        }
        VectorAssembler assembler = VectorAssemblerWrapper.getOperator(inputCol, outputCol);
        Dataset tdata = assembler.transform(result);
        return tdata;
    }

    public static Dataset<Row> transform(VectorAssembler assembler, Dataset<Row> data) {
        Dataset tdata = assembler.transform(data);
        return tdata;
    }
}

