/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.DataSetOperator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.parquet.Strings;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.util.MLWritable;

public class ModelExplanation
implements DataSetOperator {
    public static void main(String[] args) {
        String str = "RandomForestClassificationModel (uid=rfc_ab163b1bdcde) with 10 trees\n  Tree 0 (weight 1.0):\n    If (feature 552 <= 0.0)\n     If (feature 456 <= 0.0)\n      Predict: 0.0\n     Else (feature 456 > 0.0)\n      Predict: 1.0\n    Else (feature 552 > 0.0)\n     If (feature 121 in {2.0})\n      Predict: 0.0\n     Else (feature 121 not in {2.0})\n      If (feature 544 <= 227.0)\n       Predict: 1.0\n      Else (feature 544 > 227.0)\n       Predict: 0.0\n  Tree 1 (weight 1.0):\n    If (feature 463 <= 0.0)\n     If (feature 631 <= 0.0)\n      Predict: 0.0\n     Else (feature 631 > 0.0)\n      If (feature 544 <= 156.0)\n       Predict: 1.0\n      Else (feature 544 > 156.0)\n       Predict: 0.0\n    Else (feature 463 > 0.0)\n     Predict: 0.0\n  Tree 2 (weight 1.0):\n    If (feature 385 <= 0.0)\n     If (feature 350 <= 0.0)\n      Predict: 1.0\n     Else (feature 350 > 0.0)\n      Predict: 0.0\n    Else (feature 385 > 0.0)\n     Predict: 1.0\n  Tree 3 (weight 1.0):\n    If (feature 328 <= 0.0)\n     If (feature 261 <= 0.0)\n      Predict: 0.0\n     Else (feature 261 > 0.0)\n      Predict: 1.0\n    Else (feature 328 > 0.0)\n     Predict: 1.0\n  Tree 4 (weight 1.0):\n    If (feature 429 <= 0.0)\n     If (feature 358 <= 0.0)\n      Predict: 0.0\n     Else (feature 358 > 0.0)\n      Predict: 1.0\n    Else (feature 429 > 0.0)\n     Predict: 1.0\n  Tree 5 (weight 1.0):\n    If (feature 462 <= 0.0)\n     Predict: 1.0\n    Else (feature 462 > 0.0)\n     Predict: 0.0\n  Tree 6 (weight 1.0):\n    If (feature 512 <= 0.0)\n     If (feature 413 <= 0.0)\n      Predict: 0.0\n     Else (feature 413 > 0.0)\n      Predict: 1.0\n    Else (feature 512 > 0.0)\n     Predict: 1.0\n  Tree 7 (weight 1.0):\n    If (feature 512 <= 0.0)\n     If (feature 288 <= 0.0)\n      Predict: 0.0\n     Else (feature 288 > 0.0)\n      Predict: 1.0\n    Else (feature 512 > 0.0)\n     Predict: 1.0\n  Tree 8 (weight 1.0):\n    If (feature 462 <= 0.0)\n     Predict: 1.0\n    Else (feature 462 > 0.0)\n     Predict: 0.0\n  Tree 9 (weight 1.0):\n    If (feature 385 <= 0.0)\n     If (feature 578 <= 35.0)\n      Predict: 0.0\n     Else (feature 578 > 35.0)\n      If (feature 605 <= 233.0)\n       Predict: 0.0\n      Else (feature 605 > 233.0)\n       Predict: 1.0\n    Else (feature 385 > 0.0)\n     Predict: 1.0\n";
        JSONObject jsonObject = ModelExplanation.a(str);
        System.out.println(jsonObject);
    }

    public static String explain(MLWritable writable) {
        try {
            Method method;
            Optional<Transformer> treeModel;
            if (writable instanceof PipelineModel && (treeModel = Arrays.stream(((PipelineModel)writable).stages()).filter(p2 -> {
                try {
                    Method tmpMethod = p2.getClass().getMethod("toDebugString", new Class[0]);
                    return tmpMethod != null;
                }
                catch (NoSuchMethodException e2) {
                    return false;
                }
            }).findFirst()).isPresent()) {
                writable = (MLWritable)treeModel.get();
            }
            if ((method = writable.getClass().getMethod("toDebugString", new Class[0])) != null) {
                String debugStr = method.invoke((Object)writable, new Object[0]).toString();
                String debugJson = ModelExplanation.a(debugStr).toJSONString();
                PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "saveModelDebugJson", new String[]{Long.class.getTypeName(), String.class.getTypeName()}, new Object[]{PersistService.getFlowId(), debugJson});
                return debugJson;
            }
            System.out.println("no such method!");
            return "no such method!";
        }
        catch (Exception e2) {
            System.out.println("not a tree model");
            System.out.println("invoke error");
            return "invoke error";
        }
    }

    private static JSONObject a(String debugStr) {
        String[] split = debugStr.split("\n");
        ArrayList<String> list = new ArrayList<String>();
        JSONArray jsonArray = new JSONArray();
        JSONObject result = new JSONObject();
        int titlePos = 1;
        for (int i2 = 0; i2 < split.length; ++i2) {
            if (i2 == 0) {
                result.put("title", (Object)split[i2].trim());
                continue;
            }
            if (split[i2].trim().startsWith("Tree") && list.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("title", (Object)split[titlePos].trim());
                int firstCharPos = ModelExplanation.b(list.get(0));
                int elsePos = ModelExplanation.a(list, firstCharPos, 1, list.size());
                ModelExplanation.a(jsonObject, list, 0, elsePos, list.size());
                jsonArray.add(jsonObject);
                titlePos = i2;
                list.clear();
                continue;
            }
            if (split[i2].trim().startsWith("Tree")) continue;
            list.add(split[i2]);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("title", (Object)split[titlePos].trim());
        int firstCharPos = ModelExplanation.b((String)list.get(0));
        int elsePos = ModelExplanation.a(list, firstCharPos, 1, list.size());
        ModelExplanation.a(jsonObject, list, 0, elsePos, list.size());
        jsonArray.add(jsonObject);
        result.put("num", (Object)jsonArray.size());
        result.put("trees", (Object)jsonArray);
        return result;
    }

    private static void a(JSONObject jsonObject, List<String> list, int lIndex, int rIndex, int end) {
        JSONObject rightJson;
        int elsePos;
        int firstCharPos;
        JSONObject leftJson;
        assert (lIndex < rIndex && rIndex < end);
        jsonObject.put("value", (Object)list.get(lIndex).trim().replace("If", "").replace("(", "").replace(")", "").trim());
        if (list.get(lIndex + 1).trim().startsWith("Predict")) {
            leftJson = new JSONObject();
            leftJson.put("value", (Object)list.get(lIndex + 1).trim().replace("If", "").replace("(", "").replace(")", "").trim());
            jsonObject.put("left", (Object)leftJson);
        } else if (list.get(lIndex + 1).trim().startsWith("If")) {
            leftJson = new JSONObject();
            jsonObject.put("left", (Object)leftJson);
            firstCharPos = ModelExplanation.b(list.get(lIndex + 1));
            elsePos = ModelExplanation.a(list, firstCharPos, lIndex + 2, rIndex);
            ModelExplanation.a(leftJson, list, lIndex + 1, elsePos, rIndex);
        }
        if (list.get(rIndex + 1).trim().startsWith("Predict")) {
            rightJson = new JSONObject();
            rightJson.put("value", (Object)list.get(rIndex + 1).trim().replace("If", "").replace("(", "").replace(")", "").trim());
            jsonObject.put("right", (Object)rightJson);
        } else if (list.get(rIndex + 1).trim().startsWith("If")) {
            rightJson = new JSONObject();
            jsonObject.put("right", (Object)rightJson);
            firstCharPos = ModelExplanation.b(list.get(rIndex + 1));
            elsePos = ModelExplanation.a(list, firstCharPos, rIndex + 2, end);
            ModelExplanation.a(rightJson, list, rIndex + 1, elsePos, end);
        }
    }

    private static int b(String line) {
        int index = -1;
        if (!Strings.isNullOrEmpty((String)line)) {
            int i2;
            for (i2 = 0; i2 < line.length() && line.charAt(i2) == ' '; ++i2) {
            }
            index = i2;
        }
        return index;
    }

    private static int a(List<String> list, int condition, int start2, int end) {
        int pos = -1;
        for (int i2 = start2; i2 < end; ++i2) {
            if (ModelExplanation.b(list.get(i2)) != condition) continue;
            pos = i2;
            break;
        }
        return pos;
    }
}

